/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.page;

import com.atlassian.fecru.page.PageRequest;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;

public class Page<T>
implements Serializable {
    private int start;
    private int limit;
    private boolean lastPage;
    private int size;
    private ImmutableList<T> values;

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }

    public int getSize() {
        return this.size;
    }

    public Iterable<T> getValues() {
        return this.values;
    }

    @Nonnull
    public <U> Page<U> transform(Function<T, U> transformFunction) {
        Page<T> page = new Page<T>();
        page.start = this.start;
        page.limit = this.limit;
        page.lastPage = this.lastPage;
        page.values = ImmutableList.copyOf((Iterable)Iterables.transform(this.values, transformFunction));
        page.size = this.size;
        return page;
    }

    public static <T> Page<T> empty() {
        Page<T> page = new Page<T>();
        page.start = 0;
        page.lastPage = true;
        page.values = ImmutableList.of();
        page.size = 0;
        return page;
    }

    public PageRequest getNextPageRequest() {
        if (this.lastPage) {
            throw new IllegalStateException("There is no next page");
        }
        return PageRequest.create(this.start + this.limit, this.limit);
    }

    public static class Builder<T> {
        private Integer start;
        private Integer limit;
        private Boolean lastPage;
        private ImmutableList<T> values;
        private Integer size;

        public Builder<T> start(int start) {
            this.start = start;
            return this;
        }

        public Builder<T> limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder<T> pageRequest(PageRequest pageRequest) {
            this.start(pageRequest.getStart());
            this.limit(pageRequest.getLimit());
            return this;
        }

        public Builder<T> lastPage(boolean lastPage) {
            this.lastPage = lastPage;
            return this;
        }

        public Builder<T> values(Iterable<T> values) {
            this.values = ImmutableList.copyOf(values);
            return this;
        }

        public Builder<T> size(int size) {
            this.size = size;
            return this;
        }

        public Page<T> build() {
            Preconditions.checkNotNull((Object)this.start, (Object)"start not set");
            Preconditions.checkArgument((this.start >= 0 ? 1 : 0) != 0, (Object)"start is negative");
            Preconditions.checkNotNull((Object)this.limit, (Object)"limit not set");
            Preconditions.checkArgument((this.limit >= 0 ? 1 : 0) != 0, (Object)"limit  is negative");
            Preconditions.checkNotNull((Object)this.lastPage, (Object)"lastPage not set");
            Preconditions.checkNotNull(this.values, (Object)"values not set");
            Preconditions.checkNotNull((Object)this.size, (Object)"size not set");
            Preconditions.checkArgument((this.size >= 0 ? 1 : 0) != 0, (Object)"size is negative");
            Preconditions.checkArgument((this.size <= this.limit ? 1 : 0) != 0, (String)"size is greater then limit, %s > %s", (Object[])new Object[]{this.size, this.limit});
            Page page = new Page();
            page.start = this.start;
            page.limit = this.limit;
            page.lastPage = this.lastPage;
            page.values = this.values;
            page.size = this.size;
            return page;
        }

        public static <T> Page<T> buildFromLimitPlusOneCollection(Collection<T> limitPlusOne, PageRequest pageRequest) {
            Preconditions.checkArgument((limitPlusOne.size() <= pageRequest.getLimit() + 1 ? 1 : 0) != 0, (String)"Wrong size of nPlusOne. Size of collection: %d is greater then limit: %d + 1", (Object[])new Object[]{limitPlusOne.size(), pageRequest.getLimit()});
            return new Builder<T>().start(pageRequest.getStart()).limit(pageRequest.getLimit()).values(Iterables.limit(limitPlusOne, (int)pageRequest.getLimit())).size(Math.min(limitPlusOne.size(), pageRequest.getLimit())).lastPage(limitPlusOne.size() <= pageRequest.getLimit()).build();
        }

        public static <T> Page<T> buildFromAllDataCollection(Collection<T> allData, PageRequest pageRequest) {
            return Builder.buildFromAllDataIterable(allData, pageRequest);
        }

        public static <T> Page<T> buildFromAllDataIterable(Iterable<T> allData, PageRequest pageRequest) {
            Iterator<T> allDataIterator = allData.iterator();
            Iterators.advance(allDataIterator, (int)pageRequest.getStart());
            ImmutableList values = ImmutableList.copyOf((Iterator)Iterators.limit(allDataIterator, (int)pageRequest.getLimit()));
            boolean lastPage = !allDataIterator.hasNext();
            return new Builder<T>().start(pageRequest.getStart()).limit(pageRequest.getLimit()).values((Iterable<T>)values).size(values.size()).lastPage(lastPage).build();
        }
    }
}

