/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

public class CaseAwarePath {
    private String path;
    private boolean caseSensitive;

    public CaseAwarePath(String path) {
        this(path, false);
    }

    public CaseAwarePath(String path, boolean caseSensitive) {
        this.setPath(path);
        this.setCaseSensitive(caseSensitive);
    }

    public CaseAwarePath(CaseAwarePath other) {
        this(other.getPath(), other.isCaseSensitive());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String toString() {
        return String.format("<Path (case %s): %s>", this.caseSensitive ? "sensitive" : "insensitive", this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CaseAwarePath)) {
            return false;
        }
        CaseAwarePath that = (CaseAwarePath)o;
        return that.caseSensitive == this.caseSensitive && that.path.equals(this.path);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.path.hashCode();
        result = 31 * result + (this.caseSensitive ? 1 : 0);
        return result;
    }
}

