/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.ManagedRepositoriesNotSupportedException;
import com.atlassian.fisheye.spi.admin.data.AdvancedLinker;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePath;
import com.atlassian.fisheye.spi.admin.data.CaseAwarePathGlob;
import com.atlassian.fisheye.spi.admin.data.CommitMessageSyntaxSettings;
import com.atlassian.fisheye.spi.admin.data.DefaultUpdateOptions;
import com.atlassian.fisheye.spi.admin.data.RepositoryOptions;
import com.atlassian.fisheye.spi.admin.data.SimpleLinker;
import com.atlassian.fisheye.spi.admin.data.TarballSettings;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DefaultRepositoryOptions {
    private final RepositoryOptions options;

    public DefaultRepositoryOptions() {
        this.options = new RepositoryOptions();
        this.options.setAllowAnon(false);
        this.options.setWatchesEnabled(false);
        this.options.setChangesetDiscussionsEnabled(false);
        this.options.setMaxIndexableSize(0x500000L);
        this.options.setShowCheckoutURL(false);
    }

    public DefaultRepositoryOptions(RepositoryOptions repositoryOptions) {
        if (repositoryOptions.isChangesetDiscussionsEnabled() == null) {
            throw new IllegalArgumentException("The repository option changesetDiscussionsEnabled must not be null");
        }
        if (repositoryOptions.getTarballSettings() == null) {
            throw new IllegalArgumentException("The repository option tarballEnabled must not be null");
        }
        if (repositoryOptions.isWatchesEnabled() == null) {
            throw new IllegalArgumentException("The repository option watchesEnabled must not be null");
        }
        this.options = new RepositoryOptions(repositoryOptions);
    }

    public static RepositoryOptions newRepositoryOptions(DefaultRepositoryOptions defaultOptions) {
        return new RepositoryOptions(defaultOptions.options);
    }

    public List<SimpleLinker> getSimpleLinkers() {
        return this.options.getSimpleLinkers();
    }

    public void setSimpleLinkers(List<SimpleLinker> simpleLinkers) {
        this.options.setSimpleLinkers(simpleLinkers);
    }

    public List<AdvancedLinker> getAdvancedLinkers() {
        return this.options.getAdvancedLinkers();
    }

    public void setAdvancedLinkers(List<AdvancedLinker> advancedLinkers) {
        this.options.setAdvancedLinkers(advancedLinkers);
    }

    public boolean isWatchesEnabled() {
        return this.options.isWatchesEnabled();
    }

    public void setWatchesEnabled(boolean enable) {
        this.options.setWatchesEnabled(enable);
    }

    public boolean isAllowAnon() {
        return this.options.isAllowAnon();
    }

    public void setAllowAnon(boolean allowAnon) {
        this.options.setAllowAnon(allowAnon);
    }

    @Deprecated
    public boolean isAllowAnonWrite() {
        return false;
    }

    @Deprecated
    public void setAllowAnonWrite(boolean allowAnonWrite) {
        throw new ManagedRepositoriesNotSupportedException();
    }

    public boolean isAllowLoggedUsers() {
        return this.options.isAllowLoggedUsers();
    }

    public void setAllowLoggedUsers(boolean allowLoggedUsers) {
        this.options.setAllowLoggedUsers(allowLoggedUsers);
    }

    @Deprecated
    public boolean isAllowLoggedUsersWrite() {
        return false;
    }

    @Deprecated
    public void setAllowLoggedUsersWrite(boolean allowLoggedUsersWrite) {
        throw new ManagedRepositoriesNotSupportedException();
    }

    public List<CaseAwarePath> getAllowIncludes() {
        return this.options.getAllowIncludes();
    }

    public void setAllowIncludes(List<CaseAwarePath> allowIncludes) {
        this.options.setAllowIncludes(allowIncludes);
    }

    public List<CaseAwarePathGlob> getAllowExcludes() {
        return this.options.getAllowExcludes();
    }

    public void setAllowExcludes(List<CaseAwarePathGlob> allowExcludes) {
        this.options.setAllowExcludes(allowExcludes);
    }

    public List<CaseAwarePath> getHiddenDirectories() {
        return this.options.getHiddenDirectories();
    }

    public void setHiddenDirectories(List<CaseAwarePath> hiddenDirectories) {
        this.options.setHiddenDirectories(hiddenDirectories);
    }

    public TarballSettings getTarballSettings() {
        return this.options.getTarballSettings();
    }

    public void setTarballSettings(TarballSettings tarballSettings) {
        if (tarballSettings == null) {
            throw new NullPointerException("tarballSettings must not be null.");
        }
        this.options.setTarballSettings(tarballSettings);
    }

    public void setChangesetDiscussionsEnabled(boolean allow) {
        this.options.setChangesetDiscussionsEnabled(allow);
    }

    public boolean isChangesetDiscussionsEnabled() {
        return this.options.isChangesetDiscussionsEnabled();
    }

    public CommitMessageSyntaxSettings getCommitMessageSyntaxSettings() {
        return this.options.getCommitMessageSyntaxSettings();
    }

    public void setCommitMessageSyntaxSettings(CommitMessageSyntaxSettings commitMessageSyntaxSettings) {
        if (commitMessageSyntaxSettings == null) {
            throw new NullPointerException("commitMessageSyntaxSettings must not be null.");
        }
        this.options.setCommitMessageSyntaxSettings(commitMessageSyntaxSettings);
    }

    @Deprecated
    public void setRequiredGroups(Set<String> groups) {
        if (groups == null) {
            throw new NullPointerException("groups must not be null.");
        }
        this.options.setRequiredGroups(groups);
    }

    @Deprecated
    public Set<String> getRequiredGroups() {
        return this.options.getRequiredGroups();
    }

    @Deprecated
    public Set<String> getRequiredWriteGroups() {
        return Collections.emptySet();
    }

    @Deprecated
    public void setRequiredWriteGroups(Set<String> requiredWriteGroups) {
        throw new ManagedRepositoriesNotSupportedException();
    }

    public Long getMaxIndexableSize() {
        return this.options.getMaxIndexableSize();
    }

    public void setMaxIndexableSize(Long maxIndexableSize) {
        this.options.setMaxIndexableSize(maxIndexableSize);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRepositoryOptions)) {
            return false;
        }
        DefaultRepositoryOptions that = (DefaultRepositoryOptions)o;
        return that.options.equals(this.options);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.options.hashCode();
        return result;
    }

    public void setUpdateOptions(DefaultUpdateOptions updateOptions) {
        this.options.setUpdateOptions(updateOptions);
    }

    public DefaultUpdateOptions getUpdateOptions() {
        return (DefaultUpdateOptions)this.options.getUpdateOptions();
    }

    public Boolean getShowCheckoutURLs() {
        return this.options.getShowCheckoutURL();
    }

    public void setShowCheckoutURLs(Boolean showCheckoutURLs) {
        this.options.setShowCheckoutURL(showCheckoutURLs);
    }
}

