/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import com.atlassian.fisheye.spi.admin.data.AuthenticationData;
import com.atlassian.fisheye.spi.admin.data.HasAuthenticationData;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.util.FieldValidator;

public class HgRepositoryData
extends RepositoryData
implements HasAuthenticationData {
    private String location;
    private AuthenticationData authenticationData;
    private String path;
    private String commandTimeout;
    private Integer blockSize;

    @Deprecated
    public HgRepositoryData(String name, String location) {
        this(name, name, location);
    }

    public HgRepositoryData(String name, String displayName, String location) {
        super(name, displayName);
        this.setLocation(location);
    }

    @Override
    public RepositoryData.Type getType() {
        return RepositoryData.Type.HG;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        FieldValidator.INSTANCE.notBlank("location", location);
        this.location = location;
    }

    @Override
    public AuthenticationData getAuthentication() {
        return this.authenticationData;
    }

    @Override
    public void setAuthentication(AuthenticationData authenticationData) {
        this.authenticationData = authenticationData;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        FieldValidator.INSTANCE.positive("blockSize", blockSize);
        this.blockSize = blockSize;
    }

    @Override
    public String getLocationDescription() {
        String cleanPath;
        String cleanLocation = this.location == null || this.location.length() == 0 ? "" : this.location;
        String string = cleanPath = this.path == null || this.path.length() == 0 ? "" : this.path;
        if (cleanLocation.endsWith("/")) {
            cleanLocation = cleanLocation.substring(0, cleanLocation.length() - 1);
        }
        if (cleanPath.startsWith("/")) {
            cleanPath = cleanPath.substring(1);
        }
        return cleanLocation + "/" + cleanPath;
    }

    public String getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setCommandTimeout(String commandTimeout) {
        FieldValidator.INSTANCE.validTimeString("commandTimeout", commandTimeout);
        this.commandTimeout = commandTimeout;
    }
}

