/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import java.util.Date;
import java.util.Map;

public class RepositoryIndexingStatus {
    private final boolean full;
    private final boolean incremental;
    private final boolean loc;
    private final boolean error;
    private final String message;
    private final Date lastScanTime;
    private final boolean initialIndexingComplete;
    private final boolean initialScanningComplete;
    private final boolean crossRepositoryRescanInProgress;
    private final Map<String, ? extends Number> indexingStateCounts;

    private RepositoryIndexingStatus(Builder builder) {
        this.full = builder.full;
        this.incremental = builder.incremental;
        this.loc = builder.loc;
        this.error = builder.error;
        this.message = builder.message;
        this.lastScanTime = builder.lastScanTime;
        this.indexingStateCounts = builder.indexingStateCounts;
        this.initialIndexingComplete = builder.initialIndexingComplete;
        this.initialScanningComplete = builder.initialScanningComplete;
        this.crossRepositoryRescanInProgress = builder.crossRepositoryRescanInProgress;
    }

    public Date getLastScanTime() {
        return this.lastScanTime;
    }

    public boolean isFullIndexingInProgress() {
        return this.full;
    }

    public boolean isIncrementalIndexingInProgress() {
        return this.incremental;
    }

    public boolean isLinesOfContentIndexingInProgress() {
        return this.loc;
    }

    public boolean hasError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, ? extends Number> getIndexingStateCounts() {
        return this.indexingStateCounts;
    }

    public boolean isDoneFullRepositorySlurp() {
        return this.initialIndexingComplete;
    }

    public boolean isInitialScanningComplete() {
        return this.initialScanningComplete;
    }

    public boolean isCrossRepositoryRescanInProgress() {
        return this.crossRepositoryRescanInProgress;
    }

    public static class Builder {
        private boolean full = false;
        private boolean incremental = false;
        private boolean loc = false;
        private boolean error = false;
        private String message = "";
        private Date lastScanTime;
        private boolean initialIndexingComplete = false;
        private Map<String, ? extends Number> indexingStateCounts;
        public boolean initialScanningComplete;
        public boolean crossRepositoryRescanInProgress;

        public Builder fullIndex(boolean full) {
            this.full = full;
            return this;
        }

        public Builder incrementalIndex(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        public Builder locIndex(boolean loc) {
            this.loc = loc;
            return this;
        }

        public Builder hasError(boolean error) {
            this.error = error;
            return this;
        }

        public Builder message(String message) {
            this.message = message == null ? "" : message;
            return this;
        }

        public Builder lastScanTime(Date date) {
            this.lastScanTime = date;
            return this;
        }

        public Builder indexingStateCounts(Map<String, ? extends Number> indexingStateCounts) {
            this.indexingStateCounts = indexingStateCounts;
            return this;
        }

        public Builder doneFullRepositorySlurp(boolean initialIndexingComplete) {
            this.initialIndexingComplete = initialIndexingComplete;
            return this;
        }

        public Builder initialScanningComplete(boolean initialScanningComplete) {
            this.initialScanningComplete = initialScanningComplete;
            return this;
        }

        public Builder crossRepositoryRescanInProgress(boolean crossRepositoryRescanInProgress) {
            this.crossRepositoryRescanInProgress = crossRepositoryRescanInProgress;
            return this;
        }

        public RepositoryIndexingStatus build() {
            return new RepositoryIndexingStatus(this);
        }
    }
}

