/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.spi.admin.data;

import java.util.ArrayList;
import java.util.List;

public class TarballSettings {
    private List<Exclude> excludes;
    private long maxFiles;
    private boolean enabled;

    public TarballSettings() {
        this(new ArrayList<Exclude>());
    }

    public TarballSettings(List<Exclude> excludes) {
        this(excludes, 0L, false);
    }

    public TarballSettings(TarballSettings tarballSettings) {
        this(new ArrayList<Exclude>(), tarballSettings.getMaxFiles(), tarballSettings.isEnabled());
        for (Exclude exclude : tarballSettings.getExcludes()) {
            this.excludes.add(new Exclude(exclude));
        }
    }

    public TarballSettings(List<Exclude> excludes, long maxFiles, boolean enabled) {
        this.setExcludes(excludes);
        this.setMaxFiles(maxFiles);
        this.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<Exclude> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<Exclude> excludes) {
        if (excludes == null) {
            throw new NullPointerException();
        }
        this.excludes = excludes;
    }

    public long getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(long maxFiles) {
        if (maxFiles < 0L) {
            throw new IllegalArgumentException("maxFiles must not be negative");
        }
        this.maxFiles = maxFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TarballSettings)) {
            return false;
        }
        TarballSettings that = (TarballSettings)o;
        return that.enabled == this.enabled && that.maxFiles == this.maxFiles && that.excludes.equals(this.excludes);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.excludes.hashCode();
        result = 31 * result + (int)(this.maxFiles ^ this.maxFiles >>> 32);
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }

    public static class Exclude {
        private String directoryPath;
        private boolean excludeSubDirs;

        public Exclude(String directoryPath) {
            this(directoryPath, false);
        }

        public Exclude(String directoryPath, boolean excludeSubDirs) {
            this.setDirectoryPath(directoryPath);
            this.setExcludeSubDirs(excludeSubDirs);
        }

        public Exclude(Exclude exclude) {
            this(exclude.getDirectoryPath(), exclude.isExcludeSubDirs());
        }

        public String getDirectoryPath() {
            return this.directoryPath;
        }

        public void setDirectoryPath(String directoryPath) {
            if (directoryPath == null) {
                throw new NullPointerException();
            }
            this.directoryPath = directoryPath;
        }

        public boolean isExcludeSubDirs() {
            return this.excludeSubDirs;
        }

        public void setExcludeSubDirs(boolean excludeSubDirs) {
            this.excludeSubDirs = excludeSubDirs;
        }

        public String toString() {
            return String.format("<Exclude %s '%s'>", this.excludeSubDirs ? "dir" : "dir (and sub dirs)", this.directoryPath);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Exclude)) {
                return false;
            }
            Exclude that = (Exclude)o;
            return that.excludeSubDirs == this.excludeSubDirs && that.directoryPath.equals(this.directoryPath);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.excludeSubDirs ? 1 : 0);
            result = 31 * result + this.directoryPath.hashCode();
            return result;
        }
    }
}

