/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import be.roam.hue.doj.Doj;
import com.atlassian.integrationtesting.ui.RestoreFromBackupException;
import com.atlassian.integrationtesting.ui.UiTester;
import com.atlassian.sal.api.ApplicationProperties;
import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.RefreshHandler;
import com.gargoylesoftware.htmlunit.WaitingRefreshHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public final class CompositeUiTester
implements UiTester {
    public static final long DELAY_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    public static final long TIMEOUT = TimeUnit.SECONDS.toMillis(2L);
    private final ApplicationProperties applicationProperties;
    private final WebClient webClient;
    private final Function<Login, HtmlPage> login;
    private final Function<WebSudoLogin, HtmlPage> webSudoLogin;
    private final Function<UiTester, Void> logout;
    private final Function<UiTester, String> getLoggedInUser;
    private final Function<UiTester, Boolean> isOnLogInPage;
    private final Function<Backup, Void> restore;
    private HtmlPage currentPage;
    private boolean loggedIn;

    CompositeUiTester(ApplicationProperties applicationProperties, Function<Login, HtmlPage> login, Function<WebSudoLogin, HtmlPage> webSudoLogin, Function<UiTester, Void> logout, Function<UiTester, String> getLoggedInUser, Function<UiTester, Boolean> isOnLogInPage, Function<Backup, Void> restore) {
        this.applicationProperties = applicationProperties;
        this.webClient = new WebClient(BrowserVersion.INTERNET_EXPLORER_11);
        this.webClient.getOptions().setThrowExceptionOnScriptError(false);
        this.webClient.setRefreshHandler((RefreshHandler)new WaitingRefreshHandler());
        this.webClient.setAlertHandler(new AlertHandler(){

            public void handleAlert(Page page, String message) {
                System.out.println("ALERT: " + message);
            }
        });
        this.login = login;
        this.webSudoLogin = webSudoLogin;
        this.logout = logout;
        this.getLoggedInUser = getLoggedInUser;
        this.isOnLogInPage = isOnLogInPage;
        this.restore = restore;
    }

    @Override
    public String getLoggedInUser() {
        if (!this.loggedIn) {
            return null;
        }
        return (String)this.getLoggedInUser.apply((Object)this);
    }

    @Override
    public boolean isOnLoginPage() {
        return (Boolean)this.isOnLogInPage.apply((Object)this);
    }

    @Override
    public void destroy() {
        this.webClient.closeAllWindows();
    }

    @Override
    public String getBaseUrl() {
        return this.applicationProperties.getBaseUrl();
    }

    @Override
    public void logInAs(String username) {
        if (this.loggedIn) {
            throw new IllegalStateException("already logged in");
        }
        if (this.currentPage == null) {
            this.gotoPage("");
        }
        this.currentPage = (HtmlPage)this.login.apply((Object)new Login(this, username));
        this.currentPage = (HtmlPage)this.webSudoLogin.apply((Object)new WebSudoLogin(this, username));
        this.loggedIn = true;
    }

    @Override
    public void logout() {
        if (!this.loggedIn) {
            return;
        }
        this.checkCurrentPage();
        this.logout.apply((Object)this);
        this.loggedIn = false;
    }

    @Override
    public HtmlPage gotoPage(String relativePath) {
        try {
            this.currentPage = (HtmlPage)this.webClient.getPage(this.ensureTrailingSlash(this.getBaseUrl()) + relativePath);
            this.waitForAsyncEventsThatBeginWithinDefaultTime();
            return this.currentPage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page refreshPage() {
        try {
            this.currentPage = (HtmlPage)this.currentPage.refresh();
            this.waitForAsyncEventsThatBeginWithinDefaultTime();
            return this.currentPage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getStyleClass(String elementId) {
        HtmlElement element = (HtmlElement)this.currentPage.getElementById(elementId);
        Preconditions.checkState((element != null ? 1 : 0) != 0, (Object)("Cannot find element: " + elementId));
        return element.getAttribute("class");
    }

    @Override
    public void clickElementWithId(String id) {
        HtmlElement element = (HtmlElement)this.currentPage.getElementById(id);
        Preconditions.checkState((element != null ? 1 : 0) != 0, (Object)("Cannot find element: " + id));
        try {
            element.click();
            this.waitForAsyncEventsThatBeginWithinDefaultTime();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkCurrentPage() {
        Preconditions.checkState((this.currentPage != null ? 1 : 0) != 0, (Object)"No current page found");
    }

    protected final String ensureTrailingSlash(String url) {
        return url.endsWith("/") ? url : url + "/";
    }

    @Override
    public int waitForAsyncEventsToComplete() {
        return this.waitForAsyncEventsToComplete(TIMEOUT);
    }

    @Override
    public int waitForAsyncEventsToComplete(long timeoutMillis) {
        this.checkCurrentPage();
        return this.webClient.waitForBackgroundJavaScript(timeoutMillis);
    }

    @Override
    public int waitForAsyncEventsThatBeginWithinDefaultTime() {
        return this.waitForAsyncEventsThatBeginWithin(DELAY_MILLIS);
    }

    @Override
    public int waitForAsyncEventsThatBeginWithin(long delayMillis) {
        this.checkCurrentPage();
        return this.webClient.waitForBackgroundJavaScriptStartingBefore(delayMillis);
    }

    @Override
    public HtmlElement getElementById(String id) {
        return this.currentPage.getHtmlElementById(id);
    }

    @Override
    public Doj currentPage() {
        return Doj.on((HtmlPage)this.currentPage);
    }

    @Override
    public String getHtmlContents() {
        return this.currentPage().getElement(0).asXml();
    }

    @Override
    public Doj elementById(String id) {
        return this.currentPage().get("#" + id);
    }

    @Override
    public void closeWindows() {
        this.webClient.closeAllWindows();
    }

    @Override
    public void restore(String backup) {
        this.restore(backup, "admin");
    }

    @Override
    public void restore(String backup, String username) {
        URL url = this.getClass().getClassLoader().getResource(backup);
        if (url == null) {
            throw new RestoreFromBackupException("Backup file " + backup + " not found");
        }
        this.restore.apply((Object)new Backup(this, url, username));
    }

    @Override
    public boolean isJavaScriptEnabled() {
        return this.webClient.getOptions().isJavaScriptEnabled();
    }

    @Override
    public void setJavaScriptEnabled(boolean enabled) {
        this.webClient.getOptions().setJavaScriptEnabled(enabled);
    }

    public static final class Backup {
        public final UiTester client;
        public final URL data;
        public final String username;

        public Backup(UiTester client, URL data, String username) {
            this.client = client;
            this.data = data;
            this.username = username;
        }

        public String toString() {
            return "Backup(" + this.data.toString() + ")";
        }
    }

    public static final class WebSudoLogin {
        public final UiTester client;
        public final String password;

        public WebSudoLogin(UiTester client, String password) {
            this.client = client;
            this.password = password;
        }
    }

    public static final class Login {
        public final UiTester client;
        public final String username;

        public Login(UiTester client, String username) {
            this.client = client;
            this.username = username;
        }
    }
}

