/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import be.roam.hue.doj.Doj;
import com.atlassian.integrationtesting.runner.restore.RestoreFromBackup;
import com.atlassian.integrationtesting.ui.CompositeUiTester;
import com.atlassian.integrationtesting.ui.UiTester;
import com.atlassian.integrationtesting.ui.UiTesterFunctionProvider;
import com.atlassian.integrationtesting.ui.UiTesters;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import java.io.IOException;

public enum Confluence implements UiTesterFunctionProvider
{
    v3_4,
    v3_5,
    v4_0,
    v5_6;

    private final Function<UiTester, Void> logout = UiTesters.goToPageToLogout("logout.action");
    private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("login.action").formName("loginform").submitButtonId("loginButton").build();
    private final Function<UiTester, Boolean> isOnLogInPage = UiTesters.isOnLogInPageByFormName("loginform");

    @Override
    public Function<UiTester, Void> logout() {
        return this.logout;
    }

    @Override
    public Function<CompositeUiTester.Login, HtmlPage> logIn() {
        return this.logIn;
    }

    @Override
    public Function<UiTester, Boolean> isOnLogInPage() {
        return this.isOnLogInPage;
    }

    @Override
    public Function<UiTester, String> getLoggedInUser() {
        return UiTesters.getLoggedInUser();
    }

    @Override
    public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
        return ConfluenceWebSudoLogin.INSTANCE;
    }

    @Override
    public Function<CompositeUiTester.Backup, Void> restore() {
        return RestoreFromBackup.UsingRestResource.INSTANCE;
    }

    private static enum ConfluenceWebSudoLogin implements Function<CompositeUiTester.WebSudoLogin, HtmlPage>
    {
        INSTANCE;


        public HtmlPage apply(CompositeUiTester.WebSudoLogin login) {
            login.client.gotoPage("admin/viewgeneralconfig.action");
            Doj form = login.client.currentPage().get("form").first();
            if (form != null && form.attribute("action").endsWith("doauthenticate.action")) {
                form.get("#password").value(login.password);
                try {
                    return (HtmlPage)form.get("input").withId("authenticateButton").click();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return (HtmlPage)login.client.currentPage().firstElement().getPage();
        }
    }
}

