/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import be.roam.hue.doj.Doj;
import com.atlassian.integrationtesting.common.Functions;
import com.atlassian.integrationtesting.runner.restore.RestoreFromBackup;
import com.atlassian.integrationtesting.ui.CompositeUiTester;
import com.atlassian.integrationtesting.ui.UiTester;
import com.atlassian.integrationtesting.ui.UiTesterFunctionProvider;
import com.atlassian.integrationtesting.ui.UiTesters;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import java.io.IOException;

public enum Jira implements UiTesterFunctionProvider
{
    v4_1{
        private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("login.jsp").submitButtonId("login").build();
        private final Function<UiTester, Boolean> isOnLogInPage = UiTesters.isOnLogInPageByFormId("login-form");

        @Override
        public Function<CompositeUiTester.Login, HtmlPage> logIn() {
            return this.logIn;
        }

        @Override
        public Function<UiTester, Boolean> isOnLogInPage() {
            return this.isOnLogInPage;
        }
    }
    ,
    v4_2,
    v4_3{

        @Override
        public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
            return JiraWebSudoLogin.INSTANCE;
        }
    }
    ,
    v4_4,
    v6_3{

        @Override
        public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
            return JiraWebSudoLogin.INSTANCE;
        }
    };

    private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("login.jsp").formId("login-form").submitButtonId("login-form-submit").build();
    private final Function<UiTester, Boolean> isOnLogInPage = UiTesters.isOnLogInPageByFormId("login-form");
    private final Function<UiTester, Void> logout = new Function<UiTester, Void>(){
        final Function<UiTester, Void> goToLogOutPage = UiTesters.goToPageToLogout("secure/Logout!default.jspa");

        public Void apply(UiTester uiTester) {
            return UiTesters.withJavascriptDisabled(uiTester, Functions.partiallyApply(this.goToLogOutPage, uiTester));
        }
    };

    @Override
    public Function<CompositeUiTester.Login, HtmlPage> logIn() {
        return this.logIn;
    }

    @Override
    public Function<UiTester, Boolean> isOnLogInPage() {
        return this.isOnLogInPage;
    }

    @Override
    public Function<UiTester, Void> logout() {
        return this.logout;
    }

    @Override
    public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
        return UiTesters.doNothingWebSudoLogin();
    }

    @Override
    public Function<UiTester, String> getLoggedInUser() {
        return UiTesters.getLoggedInUser();
    }

    @Override
    public Function<CompositeUiTester.Backup, Void> restore() {
        return RestoreFromBackup.UsingRestResource.INSTANCE;
    }

    private static enum JiraWebSudoLogin implements Function<CompositeUiTester.WebSudoLogin, HtmlPage>
    {
        INSTANCE;


        public HtmlPage apply(CompositeUiTester.WebSudoLogin login) {
            login.client.gotoPage("secure/admin/XmlRestore!default.jspa");
            Doj form = login.client.currentPage().get("form").first();
            if (form != null && form.attribute("action").endsWith("WebSudoAuthenticate.jspa")) {
                form.getById("login-form-authenticatePassword").value(login.password);
                try {
                    return (HtmlPage)form.get("input").withId("authenticateButton").click();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return (HtmlPage)login.client.currentPage().firstElement().getPage();
        }
    }
}

