/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import be.roam.hue.doj.Doj;
import com.atlassian.integrationtesting.ui.CompositeUiTester;
import com.atlassian.integrationtesting.ui.UiTester;
import com.atlassian.integrationtesting.ui.UiTesterFunctionProvider;
import com.atlassian.integrationtesting.ui.UiTesters;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public enum RefApp implements UiTesterFunctionProvider
{
    v2_6{

        @Override
        public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
            return UiTesters.doNothingWebSudoLogin();
        }
    }
    ,
    v2_7,
    v2_23{
        private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("plugins/servlet/login").formId("login_form").submitButtonCssClass("aui-button-primary").build();
        private final Function<UiTester, Void> logout = UiTesters.goToPageToLogout("plugins/servlet/logout");

        @Override
        public Function<CompositeUiTester.Login, HtmlPage> logIn() {
            return this.logIn;
        }

        @Override
        public Function<UiTester, Void> logout() {
            return this.logout;
        }
    };

    private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("plugins/servlet/login").submitButtonName("login").build();

    @Override
    public Function<CompositeUiTester.Login, HtmlPage> logIn() {
        return this.logIn;
    }

    @Override
    public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
        return RefappWebSudoLogin.INSTANCE;
    }

    @Override
    public Function<UiTester, Void> logout() {
        return Logout.INSTANCE;
    }

    @Override
    public Function<UiTester, Boolean> isOnLogInPage() {
        return IsOnLogInPage.INSTANCE;
    }

    @Override
    public Function<UiTester, String> getLoggedInUser() {
        return UiTesters.getLoggedInUser();
    }

    @Override
    public Function<CompositeUiTester.Backup, Void> restore() {
        return UiTesters.restoreUnsupported("Refapp does not support online data restores.");
    }

    private static enum IsOnLogInPage implements Function<UiTester, Boolean>
    {
        INSTANCE;


        public Boolean apply(UiTester uiTester) {
            String action = uiTester.currentPage().get("form").attribute("action");
            return !StringUtils.isBlank((String)action) && (action.endsWith("login") || action.endsWith("logout"));
        }
    }

    private static enum Logout implements Function<UiTester, Void>
    {
        INSTANCE;


        public Void apply(UiTester uiTester) {
            HtmlPage loginPage = uiTester.gotoPage("plugins/servlet/login");
            Doj form = Doj.on((HtmlPage)loginPage).get("form").first();
            Doj logoutButton = form.get("button").withId("logout");
            Preconditions.checkState((logoutButton != null ? 1 : 0) != 0, (Object)"Unable to find logout button");
            try {
                logoutButton.click();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return null;
        }
    }

    private static enum RefappWebSudoLogin implements Function<CompositeUiTester.WebSudoLogin, HtmlPage>
    {
        INSTANCE;


        public HtmlPage apply(CompositeUiTester.WebSudoLogin login) {
            login.client.gotoPage("/plugins/servlet/websudo");
            Doj form = login.client.currentPage().get("form").first();
            if (form != null && form.attribute("action").endsWith("/plugins/servlet/websudo")) {
                form.get("#os_password").value(login.password);
                try {
                    return (HtmlPage)form.get("button").withId("websudo").click();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return (HtmlPage)login.client.currentPage().firstElement().getPage();
        }
    }
}

