/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import com.atlassian.integrationtesting.runner.ApplicationLogDelimiter;
import com.atlassian.integrationtesting.runner.CompositeTestRunner;
import com.atlassian.integrationtesting.runner.TestGroupRunner;
import com.atlassian.integrationtesting.runner.restore.RestoreFromBackup;
import com.atlassian.integrationtesting.ui.RunningTestGroup;
import com.atlassian.integrationtesting.ui.UiRunListener;
import com.atlassian.integrationtesting.ui.UiTester;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.spi.Message;
import org.apache.commons.lang.StringUtils;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.InitializationError;

public abstract class UiTestRunner
extends CompositeTestRunner {
    public UiTestRunner(Class<?> klass, Module ... modules) throws InitializationError {
        super(klass, UiTestRunner.compose(modules));
    }

    public static CompositeTestRunner.Composer compose(Module ... modules) {
        Injector injector = Guice.createInjector((Iterable)ImmutableList.builder().add((Object[])modules).add((Object)new RunningTestGroupModule()).build());
        return UiTestRunner.compose(injector);
    }

    public static CompositeTestRunner.Composer compose(Injector injector) {
        Injector child = injector.createChildInjector(new Module[]{new UiTestRunnerModule()});
        return UiTestRunner.compose().from(TestGroupRunner.compose()).from(ApplicationLogDelimiter.compose(child)).beforeTestClass(new InjectStatics(child)).beforeTestClass(new AddListener(child)).afterTestClass(new RemoveListener(child)).afterTestClass(new DestroyUiTester(child)).from(RestoreFromBackup.compose(child));
    }

    private static final class DestroyUiTester
    implements Function<CompositeTestRunner.AfterTestClass, Void> {
        private final Injector injector;

        public DestroyUiTester(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.AfterTestClass from) {
            ((UiTester)this.injector.getInstance(UiTester.class)).destroy();
            return null;
        }
    }

    private static final class RemoveListener
    implements Function<CompositeTestRunner.AfterTestClass, Void> {
        private final Injector injector;

        public RemoveListener(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.AfterTestClass test) {
            test.notifier.removeListener((RunListener)this.injector.getInstance(UiRunListener.class));
            return null;
        }
    }

    private static final class AddListener
    implements Function<CompositeTestRunner.BeforeTestClass, Void> {
        private final Injector injector;

        public AddListener(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.BeforeTestClass test) {
            test.notifier.addListener((RunListener)this.injector.getInstance(UiRunListener.class));
            return null;
        }
    }

    private static final class InjectStatics
    implements Function<CompositeTestRunner.BeforeTestClass, Void> {
        private final Injector injector;

        public InjectStatics(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.BeforeTestClass test) {
            this.injector.createChildInjector(new Module[]{new StaticInjectionModule(test.testClass.getJavaClass())});
            return null;
        }

        private static final class StaticInjectionModule
        extends AbstractModule {
            private final Class<?> testClass;

            public StaticInjectionModule(Class<?> testClass) {
                this.testClass = testClass;
            }

            protected void configure() {
                this.requestStaticInjection(new Class[]{this.testClass});
            }
        }
    }

    private static final class RunningTestGroupModule
    extends AbstractModule {
        private RunningTestGroupModule() {
        }

        protected void configure() {
            if (StringUtils.isBlank((String)TestGroupRunner.getRunningTestGroup())) {
                throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("No testGroup configured - can't figure out which UiTester to use without a test group in the form {application}-v{version}")));
            }
            this.bind(String.class).annotatedWith(RunningTestGroup.class).toInstance((Object)TestGroupRunner.getRunningTestGroup());
        }
    }

    private static final class UiTestRunnerModule
    extends AbstractModule {
        private UiTestRunnerModule() {
        }

        protected void configure() {
            this.bind(UiRunListener.class).in(Scopes.SINGLETON);
        }
    }
}

