/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import be.roam.hue.doj.Doj;
import com.atlassian.integrationtesting.common.Functions;
import com.atlassian.integrationtesting.ui.CompositeUiTester;
import com.atlassian.integrationtesting.ui.RestoreFromBackupException;
import com.atlassian.integrationtesting.ui.UiTester;
import com.atlassian.integrationtesting.ui.UiTesterFunctionProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class UiTesters {
    public static UiTester newUiTester(ApplicationProperties applicationProperties, UiTesterFunctionProvider functions) {
        return new CompositeUiTester(applicationProperties, functions.logIn(), functions.webSudoLogIn(), functions.logout(), functions.getLoggedInUser(), functions.isOnLogInPage(), functions.restore());
    }

    public static Function<UiTester, String> getLoggedInUser() {
        return GetLoggedInUser.INSTANCE;
    }

    public static Function<CompositeUiTester.WebSudoLogin, HtmlPage> doNothingWebSudoLogin() {
        return DoNothingWebSudoLogin.INSTANCE;
    }

    public static Function<UiTester, Void> goToPageToLogout(String page) {
        return new GoToPageToLogout(page);
    }

    public static LogInFunctionBuilder logInByGoingTo(String page) {
        return new LogInFunctionBuilder(page);
    }

    public static Function<UiTester, Boolean> isOnLogInPageByFormName(String formName) {
        return new IsOnLogInPageByFormName(formName);
    }

    public static Function<UiTester, Boolean> isOnLogInPageByFormId(String formId) {
        return new IsOnLogInPageByFormId(formId);
    }

    public static Function<CompositeUiTester.Backup, Void> restoreUnsupported(String reason) {
        return new RestoreUnsupported(reason);
    }

    public static Function<CompositeUiTester.Backup, Void> restore(Function<CompositeUiTester.Backup, File> processBackupData, Function<BackupFile, Void> restore) {
        return new Restore(processBackupData, restore);
    }

    public static String getHome() {
        if (StringUtils.isBlank((String)System.getProperty("homedir"))) {
            throw new RestoreFromBackupException("System property for home directory - 'homedir' - not found. If you are using AMPS, make sure you are using at least version 3.3.  If you are running from your IDE or in some other environment, you'll need to figure out how to set the 'homedir' system property for that environment.");
        }
        return System.getProperty("homedir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A> A withJavascriptDisabled(UiTester uiTester, Functions.Function0<A> f) {
        boolean isJsEnabled = uiTester.isJavaScriptEnabled();
        uiTester.setJavaScriptEnabled(false);
        try {
            A a = f.apply();
            return a;
        }
        finally {
            uiTester.setJavaScriptEnabled(isJsEnabled);
        }
    }

    public static void whenLoggedInAs(UiTester uiTester, String user, Runnable runnable) {
        uiTester.logInAs(user);
        try {
            runnable.run();
        }
        finally {
            uiTester.logout();
        }
    }

    private static final class Restore
    implements Function<CompositeUiTester.Backup, Void> {
        private final Function<CompositeUiTester.Backup, File> processBackupData;
        private final Function<BackupFile, Void> restore;

        public Restore(Function<CompositeUiTester.Backup, File> processBackupData, Function<BackupFile, Void> fn) {
            this.processBackupData = processBackupData;
            this.restore = fn;
        }

        public Void apply(CompositeUiTester.Backup backup) {
            backup.client.logInAs(backup.username);
            File dataFile = null;
            try {
                dataFile = (File)this.processBackupData.apply((Object)backup);
                this.restore.apply((Object)new BackupFile(dataFile, backup.client));
            }
            finally {
                backup.client.logout();
                if (dataFile != null) {
                    dataFile.delete();
                }
            }
            return null;
        }
    }

    public static final class BackupFile {
        public final File file;
        public final UiTester client;

        public BackupFile(File backup, UiTester client) {
            this.file = backup;
            this.client = client;
        }

        public String toString() {
            return "Backup(" + this.file.toString() + ")";
        }
    }

    private static final class RestoreUnsupported
    implements Function<CompositeUiTester.Backup, Void> {
        private final String reason;

        public RestoreUnsupported(String reason) {
            this.reason = reason;
        }

        public Void apply(CompositeUiTester.Backup backup) {
            throw new UnsupportedOperationException(this.reason);
        }
    }

    private static final class IsOnLogInPageByFormId
    implements Function<UiTester, Boolean> {
        private final String formId;

        public IsOnLogInPageByFormId(String formId) {
            this.formId = formId;
        }

        public Boolean apply(UiTester uiTester) {
            return !uiTester.currentPage().get("form").withId(this.formId).isEmpty();
        }
    }

    private static final class IsOnLogInPageByFormName
    implements Function<UiTester, Boolean> {
        private final String formName;

        public IsOnLogInPageByFormName(String formName) {
            this.formName = formName;
        }

        public Boolean apply(UiTester uiTester) {
            return !uiTester.currentPage().get("form").withName(this.formName).isEmpty();
        }
    }

    public static final class LogInFunctionBuilder {
        private final String page;
        private final String formName;
        private final String formId;
        private final String userInputName;
        private final String passwordInputName;
        private final String submitButtonId;
        private final String submitButtonName;
        private final String submitButtonCssClass;

        private LogInFunctionBuilder(String page) {
            this(page, null, null, "os_username", "os_password", null, null, null);
        }

        private LogInFunctionBuilder(String page, String formName, String formId, String userInputName, String passwordInputName, String submitButtonId, String submitButtonName, String submitButtonCssClass) {
            this.page = page;
            this.formName = formName;
            this.formId = formId;
            this.userInputName = userInputName;
            this.passwordInputName = passwordInputName;
            this.submitButtonId = submitButtonId;
            this.submitButtonName = submitButtonName;
            this.submitButtonCssClass = submitButtonCssClass;
        }

        public LogInFunctionBuilder formName(String formName) {
            return new LogInFunctionBuilder(this.page, formName, null, this.userInputName, this.passwordInputName, this.submitButtonId, this.submitButtonName, this.submitButtonCssClass);
        }

        public LogInFunctionBuilder formId(String formId) {
            return new LogInFunctionBuilder(this.page, null, formId, this.userInputName, this.passwordInputName, this.submitButtonId, this.submitButtonName, this.submitButtonCssClass);
        }

        public LogInFunctionBuilder userInputName(String userInputName) {
            return new LogInFunctionBuilder(this.page, this.formName, this.formId, userInputName, this.passwordInputName, this.submitButtonId, this.submitButtonName, this.submitButtonCssClass);
        }

        public LogInFunctionBuilder passwordInputName(String passwordInputName) {
            return new LogInFunctionBuilder(this.page, this.formName, this.formId, this.userInputName, passwordInputName, this.submitButtonId, this.submitButtonName, this.submitButtonCssClass);
        }

        public LogInFunctionBuilder submitButtonId(String submitButtonId) {
            return new LogInFunctionBuilder(this.page, this.formName, this.formId, this.userInputName, this.passwordInputName, submitButtonId, null, null);
        }

        public LogInFunctionBuilder submitButtonName(String submitButtonName) {
            return new LogInFunctionBuilder(this.page, this.formName, this.formId, this.userInputName, this.passwordInputName, null, submitButtonName, null);
        }

        public LogInFunctionBuilder submitButtonCssClass(String submitButtonCssClass) {
            return new LogInFunctionBuilder(this.page, this.formName, this.formId, this.userInputName, this.passwordInputName, null, null, submitButtonCssClass);
        }

        public Function<CompositeUiTester.Login, HtmlPage> build() {
            return new GenericLogInFunction();
        }

        private final class GenericLogInFunction
        implements Function<CompositeUiTester.Login, HtmlPage> {
            private GenericLogInFunction() {
            }

            public HtmlPage apply(CompositeUiTester.Login login) {
                Doj loginPage = Doj.on((HtmlPage)login.client.gotoPage(LogInFunctionBuilder.this.page));
                Doj loginForm = this.getLogInForm(loginPage);
                Doj os_username = loginForm.get("input").withName(LogInFunctionBuilder.this.userInputName);
                Doj os_password = loginForm.get("input").withName(LogInFunctionBuilder.this.passwordInputName);
                Doj submit = this.getSubmit(loginForm);
                boolean isJavaScriptEnabled = login.client.isJavaScriptEnabled();
                if (!(os_username.isEmpty() || os_password.isEmpty() || submit.isEmpty())) {
                    login.client.setJavaScriptEnabled(false);
                    os_username.value(login.username);
                    os_password.value(login.username);
                    try {
                        HtmlPage htmlPage = (HtmlPage)submit.click();
                        return htmlPage;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        login.client.setJavaScriptEnabled(isJavaScriptEnabled);
                    }
                }
                throw new IllegalStateException("No login form found in page " + loginPage);
            }

            private Doj getSubmit(Doj loginForm) {
                Doj submit = LogInFunctionBuilder.this.submitButtonId != null ? loginForm.getById(LogInFunctionBuilder.this.submitButtonId) : (LogInFunctionBuilder.this.submitButtonName != null ? loginForm.getByAttribute("name", LogInFunctionBuilder.this.submitButtonName) : (LogInFunctionBuilder.this.submitButtonCssClass != null ? loginForm.getByClass(LogInFunctionBuilder.this.submitButtonCssClass) : loginForm.getByTag("input").withType("submit")));
                return submit;
            }

            private Doj getLogInForm(Doj loginPage) {
                Doj loginForm = LogInFunctionBuilder.this.formName != null ? loginPage.getByTag("form").withName(LogInFunctionBuilder.this.formName).first() : (LogInFunctionBuilder.this.formId != null ? loginPage.getById(LogInFunctionBuilder.this.formId).first() : loginPage.get("form").first());
                return loginForm;
            }
        }
    }

    private static final class GoToPageToLogout
    implements Function<UiTester, Void> {
        private final String page;

        GoToPageToLogout(String page) {
            this.page = page;
        }

        public Void apply(UiTester uiTester) {
            uiTester.gotoPage(this.page);
            return null;
        }
    }

    private static enum DoNothingWebSudoLogin implements Function<CompositeUiTester.WebSudoLogin, HtmlPage>
    {
        INSTANCE;


        public HtmlPage apply(CompositeUiTester.WebSudoLogin login) {
            return (HtmlPage)login.client.currentPage().firstElement().getPage();
        }
    }

    private static enum GetLoggedInUser implements Function<UiTester, String>
    {
        INSTANCE;


        public String apply(UiTester uiTester) {
            return Doj.on((HtmlPage)uiTester.gotoPage("rest/ait/1.0/user")).getById("user").text();
        }
    }
}

