/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.compatibility.factory.issue.fields;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.compatibility.bridge.impl.issue.fields.CustomFieldHelperBridge63Impl;
import com.atlassian.jira.compatibility.bridge.impl.issue.fields.CustomFieldHelperBridge70Impl;
import com.atlassian.jira.compatibility.bridge.issue.fields.CustomFieldHelperBridge;
import com.atlassian.jira.compatibility.detection.MethodDetection;
import com.atlassian.jira.compatibility.factory.BridgeBeanFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.util.concurrent.LazyReference;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.stereotype.Component;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

@Component
public class CustomFieldHelperBridgeFactory
extends BridgeBeanFactory<CustomFieldHelperBridge> {
    @ClusterSafe(value="Local reference to stateless component")
    private final LazyReference<CustomFieldHelperBridge> customFieldHelperBridge = new LazyReference<CustomFieldHelperBridge>(){

        protected CustomFieldHelperBridge create() {
            if (CustomFieldHelperBridgeFactory.isIssueTypeCustomField()) {
                return new CustomFieldHelperBridge70Impl();
            }
            return new CustomFieldHelperBridge63Impl(ComponentAccessor.getConstantsManager());
        }
    };

    private static boolean isIssueTypeCustomField() {
        Type[] issueType = new Type[]{IssueType.class};
        ParameterizedTypeImpl issueTypeList = ParameterizedTypeImpl.make(List.class, issueType, null);
        return MethodDetection.findMethod(CustomField.class, (Type)issueTypeList, (String)"getAssociatedIssueTypes", (Class[])new Class[0]).isDefined();
    }

    public CustomFieldHelperBridgeFactory() {
        super(CustomFieldHelperBridge.class);
    }

    @Override
    public Object getObject() throws Exception {
        return this.customFieldHelperBridge.get();
    }
}

