/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.compatibility.factory.issue.watcher;

import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.compatibility.bridge.impl.issue.watcher.WatcherServiceBridge63Impl;
import com.atlassian.jira.compatibility.bridge.impl.issue.watcher.WatcherServiceBridge70Impl;
import com.atlassian.jira.compatibility.bridge.issue.watcher.WatcherServiceBridge;
import com.atlassian.jira.compatibility.detection.MethodDetection;
import com.atlassian.jira.compatibility.factory.BridgeBeanFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import org.springframework.stereotype.Component;

@Component
public class WatcherServiceBridgeFactory
extends BridgeBeanFactory<WatcherServiceBridge> {
    protected WatcherServiceBridgeFactory() {
        super(WatcherServiceBridge.class);
    }

    @Override
    public Object getObject() throws Exception {
        if (WatcherServiceBridgeFactory.isApplicationUserWatcherService()) {
            return new WatcherServiceBridge70Impl();
        }
        return new WatcherServiceBridge63Impl();
    }

    public static WatcherServiceBridge getBridge(WatcherService watcherService) {
        if (WatcherServiceBridgeFactory.isApplicationUserWatcherService()) {
            return new WatcherServiceBridge70Impl(watcherService);
        }
        return new WatcherServiceBridge63Impl(watcherService);
    }

    private static boolean isApplicationUserWatcherService() {
        return MethodDetection.findMethod(WatcherService.class, (String)"hasViewWatcherListPermission", (Class[])new Class[]{Issue.class, ApplicationUser.class}).isDefined();
    }
}

