/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Deprecated
@ExperimentalApi
public class RecordRequest {
    private final AuditingCategory category;
    private final String categoryName;
    private final String summary;
    private final ApplicationUser author;
    private final String remoteAddress;
    private final String eventSource;
    private String description;
    private String actionI18nKey;
    private AssociatedItem objectItem;
    private ImmutableList<AssociatedItem> associatedItems;
    private ImmutableList<ChangedValue> changedValues;

    public RecordRequest(@Nonnull AuditingCategory category, @Nonnull String summary, @Nonnull String eventSource, @Nullable ApplicationUser author, @Nullable String remoteAddress, @Nullable String description) {
        this.category = category;
        this.categoryName = this.getI18n().getText(category.getNameI18nKey());
        this.summary = this.getI18n().getText(summary);
        this.author = author;
        this.remoteAddress = remoteAddress;
        this.eventSource = eventSource;
        this.description = description;
        this.actionI18nKey = summary;
    }

    public RecordRequest(@Nonnull AuditingCategory category, @Nonnull String summary, @Nonnull String eventSource, @Nullable ApplicationUser author, @Nullable String remoteAddress) {
        this(category, summary, eventSource, author, remoteAddress, null);
    }

    public RecordRequest(@Nonnull AuditingCategory category, @Nonnull String summary) {
        this(category, summary, "", null, null);
    }

    public RecordRequest(@Nonnull AuditingCategory category, @Nonnull String summary, @Nonnull String eventSource) {
        this(category, summary, eventSource, null, null);
    }

    public RecordRequest forObject(@Nonnull AssociatedItem item) {
        this.objectItem = item;
        return this;
    }

    public RecordRequest forObject(@Nonnull AssociatedItem.Type type, @Nonnull String name) {
        return this.forObject(type, name, (String)null);
    }

    public RecordRequest forObject(@Nonnull AssociatedItem.Type type, @Nonnull String name, @Nullable Long id) {
        return this.forObject(type, name, id != null ? Long.toString(id) : null);
    }

    public RecordRequest forObject(@Nonnull AssociatedItem.Type type, @Nonnull String name, @Nullable String id) {
        this.objectItem = new AssociatedItemImpl(name, id, type);
        return this;
    }

    public RecordRequest withAssociatedItem(@Nonnull AssociatedItem.Type type, @Nonnull String name, @Nullable String id) {
        this.associatedItems = ImmutableList.of((Object)new AssociatedItemImpl(name, id, type));
        return this;
    }

    public RecordRequest withAssociatedItems(AssociatedItem ... items) {
        this.associatedItems = ImmutableList.copyOf((Object[])items);
        return this;
    }

    public RecordRequest withAssociatedItems(@Nonnull Iterable<AssociatedItem> items) {
        this.associatedItems = ImmutableList.copyOf(items);
        return this;
    }

    public RecordRequest withChangedValues(ChangedValue ... values) {
        this.changedValues = ImmutableList.copyOf((Object[])values);
        return this;
    }

    public RecordRequest withChangedValues(@Nonnull Iterable<ChangedValue> values) {
        this.changedValues = ImmutableList.copyOf(values);
        return this;
    }

    public RecordRequest withDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public RecordRequest withActionI18nKey(@Nonnull String actionI18nKey) {
        this.actionI18nKey = actionI18nKey;
        return this;
    }

    @Nonnull
    public String getActionI18nKey() {
        return this.actionI18nKey;
    }

    @Nonnull
    public AuditingCategory getCategory() {
        return this.category;
    }

    @Nonnull
    public String getCategoryName() {
        return this.categoryName;
    }

    @Nonnull
    public String getSummary() {
        return this.summary;
    }

    @Nonnull
    public String getEventSource() {
        return this.eventSource;
    }

    @Nullable
    public ApplicationUser getAuthor() {
        return this.author;
    }

    @Nullable
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public ImmutableList<AssociatedItem> getAssociatedItems() {
        return this.associatedItems;
    }

    public ImmutableList<ChangedValue> getChangedValues() {
        return this.changedValues;
    }

    @Nullable
    public AssociatedItem getObjectItem() {
        return this.objectItem;
    }

    protected I18nHelper getI18n() {
        return ComponentAccessor.getI18nHelperFactory().getInstance(Locale.ENGLISH);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public static class AssociatedItemImpl
    implements AssociatedItem {
        private final String name;
        private final String id;
        private final AssociatedItem.Type type;

        public AssociatedItemImpl(String name, String id, AssociatedItem.Type type) {
            this.name = name;
            this.id = id;
            this.type = type;
        }

        @Override
        @Nonnull
        public String getObjectName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getObjectId() {
            return this.id;
        }

        @Override
        @Nullable
        public String getParentName() {
            return null;
        }

        @Override
        @Nullable
        public String getParentId() {
            return null;
        }

        @Override
        @Nonnull
        public AssociatedItem.Type getObjectType() {
            return this.type;
        }

        public String toString() {
            return "AssociatedItemImpl{name='" + this.name + '\'' + ", id='" + this.id + '\'' + ", type=" + (Object)((Object)this.type) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssociatedItemImpl that = (AssociatedItemImpl)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.id, that.id) && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.id, this.type});
        }
    }
}

