/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import java.util.Objects;
import java.util.Optional;

@PublicApi
public class ProjectCreatedData {
    private final Project project;
    private final ProjectTemplateKey projectTemplateKey;
    private final Long existingProjectId;
    private final Type type;

    private ProjectCreatedData(Type type, Project project, ProjectTemplateKey projectTemplateKey, Long existingProjectId) {
        this.type = type;
        this.project = project;
        this.projectTemplateKey = projectTemplateKey;
        this.existingProjectId = existingProjectId;
    }

    public Type getType() {
        return this.type;
    }

    public Project getProject() {
        return this.project;
    }

    public Optional<ProjectTemplateKey> getProjectTemplateKey() {
        return Optional.ofNullable(this.projectTemplateKey);
    }

    public Optional<Long> getExistingProjectId() {
        return Optional.ofNullable(this.existingProjectId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectCreatedData that = (ProjectCreatedData)o;
        return Objects.equals(this.project, that.project) && Objects.equals(this.projectTemplateKey, that.projectTemplateKey) && Objects.equals(this.existingProjectId, that.existingProjectId) && Objects.equals((Object)this.type, (Object)that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.project, this.projectTemplateKey, this.existingProjectId, this.type});
    }

    public static class Builder {
        private Project project;
        private ProjectTemplateKey projectTemplateKey;
        private Long existingProjectId;

        public Builder withProject(Project project) {
            this.project = project;
            return this;
        }

        public Builder withProjectTemplateKey(ProjectTemplateKey projectTemplateKey) {
            this.projectTemplateKey = projectTemplateKey;
            return this;
        }

        public Builder withExistingProjectId(Long existingProjectId) {
            this.existingProjectId = existingProjectId;
            return this;
        }

        public ProjectCreatedData build() {
            Type type = this.existingProjectId == null ? Type.CREATE : Type.CREATE_WITH_SHARED_CONFIG;
            return new ProjectCreatedData(type, this.project, this.projectTemplateKey, this.existingProjectId);
        }
    }

    public static enum Type {
        CREATE,
        CREATE_WITH_SHARED_CONFIG;

    }
}

