/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Dates {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final DateTimeFormatter ISO_DATE_TIME_PARSER = ISODateTimeFormat.dateTime();
    public static final DateTimeFormatter ISO_DATE_TIME_PRINTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public static String asTimeString(@Nullable Date date) {
        return date != null ? new SimpleDateFormat(TIME_FORMAT).format(date) : null;
    }

    public static String asTimeString(@Nullable Timestamp timestamp) {
        return timestamp != null ? Dates.asTimeString(new Date(timestamp.getTime())) : null;
    }

    public static Date fromTimeString(@Nullable String time) throws IllegalArgumentException {
        try {
            SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
            format.setLenient(false);
            return time != null ? format.parse(time) : null;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error parsing time: " + time, e);
        }
    }

    public static String asDateString(@Nullable Date date) {
        return date != null ? new SimpleDateFormat(DATE_FORMAT).format(date) : null;
    }

    public static String asDateString(@Nullable Timestamp timestamp) {
        return timestamp != null ? Dates.asDateString(new Date(timestamp.getTime())) : null;
    }

    public static Date fromDateString(@Nullable String date) throws IllegalArgumentException {
        try {
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            format.setLenient(false);
            return date != null ? format.parse(date) : null;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error parsing date string: " + date, e);
        }
    }

    public static String asISODateTimeString(@Nullable DateTime dateTime) {
        return ISO_DATE_TIME_PRINTER.print((ReadableInstant)dateTime);
    }

    public static DateTime fromISODateTimeString(@Nullable String date) {
        DateTime parsedDateTime = date == null ? null : ISO_DATE_TIME_PARSER.parseDateTime(date);
        return parsedDateTime;
    }

    private Dates() {
    }

    public static class DateTimeDeserializer
    extends JsonDeserializer<Date> {
        public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return Dates.fromTimeString(parser.getText());
        }
    }

    public static class DateDeserializer
    extends JsonDeserializer<Date> {
        public Date deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return Dates.fromDateString(parser.getText());
        }
    }

    public static class DateTimeSerializer
    extends JsonSerializer<Date> {
        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(Dates.asTimeString(value));
        }
    }

    public static class DateSerializer
    extends JsonSerializer<Date> {
        public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(Dates.asDateString(value));
        }
    }
}

