/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowFunctionUtils;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.base.Preconditions;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.loader.WorkflowLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUtil.class);

    public static int getNextId(List descriptors) {
        return WorkflowUtil.getNextId(descriptors, 1);
    }

    public static int getNextId(List descriptors, int start) {
        int maxId = start;
        for (Object descriptor1 : descriptors) {
            AbstractDescriptor descriptor = (AbstractDescriptor)descriptor1;
            if (descriptor.getId() < maxId) continue;
            maxId = descriptor.getId() + 1;
        }
        return maxId;
    }

    public static String convertDescriptorToXML(WorkflowDescriptor descriptor) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">");
        descriptor.writeXML(writer, 0);
        writer.flush();
        writer.close();
        return stringWriter.toString();
    }

    public static boolean isAcceptableName(String workflowName, @Nonnull String fieldName, @Nonnull ErrorCollection errorCollection) {
        return WorkflowUtil.isAcceptableNameInt(workflowName, (String)Preconditions.checkNotNull((Object)fieldName), (ErrorCollection)Preconditions.checkNotNull((Object)errorCollection));
    }

    public static boolean isAcceptableName(String workflowName) {
        return WorkflowUtil.isAcceptableNameInt(workflowName, null, null);
    }

    private static boolean isAcceptableNameInt(String workflowName, @Nullable String fieldName, @Nullable ErrorCollection errorCollection) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)workflowName)) {
            WorkflowUtil.addError(errorCollection, fieldName, "admin.errors.you.must.specify.a.workflow.name");
            return false;
        }
        if (!StringUtils.isStringAllASCII((String)workflowName)) {
            WorkflowUtil.addError(errorCollection, fieldName, "admin.errors.please.use.only.ascii.characters");
            return false;
        }
        if (!workflowName.trim().equals(workflowName)) {
            WorkflowUtil.addError(errorCollection, fieldName, "admin.errors.workflow.name.cannot.contain.leading.or.trailing.whitespaces");
            return false;
        }
        return true;
    }

    private static void addError(ErrorCollection errorCollection, String fieldName, String errorKey) {
        if (errorCollection == null) {
            return;
        }
        if (fieldName == null) {
            errorCollection.addErrorMessage(WorkflowUtil.getI18nBean().getText(errorKey));
            return;
        }
        errorCollection.addError(fieldName, WorkflowUtil.getI18nBean().getText(errorKey));
    }

    public static void checkInvalidCharacters(String fieldValue, String fieldName, ErrorCollection errorCollection) {
        if (fieldValue.indexOf(60) != -1) {
            errorCollection.addError(fieldName, WorkflowUtil.getI18nBean().getText("admin.errors.invalid.character", "'<'"));
            errorCollection.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (fieldValue.indexOf(38) != -1) {
            errorCollection.addError(fieldName, WorkflowUtil.getI18nBean().getText("admin.errors.invalid.character", "'&'"));
            errorCollection.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (fieldValue.indexOf(34) != -1) {
            errorCollection.addError(fieldName, WorkflowUtil.getI18nBean().getText("admin.errors.invalid.character", "'\"'"));
            errorCollection.addReason(ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public static boolean isReservedKey(String key) {
        String normalisedKey = org.apache.commons.lang3.StringUtils.stripToNull((String)key);
        if (normalisedKey == null) {
            return false;
        }
        for (int i = 0; i < JiraWorkflow.JIRA_META_ATTRIBUTE_ALLOWED_LIST.length; ++i) {
            String allowedPrefix = JiraWorkflow.JIRA_META_ATTRIBUTE_ALLOWED_LIST[i];
            if (!normalisedKey.startsWith(allowedPrefix)) continue;
            return false;
        }
        return normalisedKey.startsWith("jira.");
    }

    public static WorkflowDescriptor convertXMLtoWorkflowDescriptor(String workflowDescriptorXML) throws FactoryException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)workflowDescriptorXML)) {
            throw new FactoryException("Error: workflow descriptor XML can not be null.");
        }
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(workflowDescriptorXML.getBytes("UTF-8"));
            WorkflowDescriptor workflowDescriptor = WorkflowLoader.load((InputStream)is, (boolean)true);
            return workflowDescriptor;
        }
        catch (Exception e) {
            throw new FactoryException("Error converting XML to workflow descriptor.", e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    log.warn("Error closing stream, while converting XML to workflow descriptor.", (Throwable)e);
                }
            }
        }
    }

    public static String getWorkflowDisplayName(JiraWorkflow workflow) {
        if (workflow == null) {
            return null;
        }
        if (workflow.isDraftWorkflow()) {
            return workflow.getName() + " (" + WorkflowUtil.getI18nBean().getText("common.words.draft") + ")";
        }
        return workflow.getName();
    }

    private static JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    public static WorkflowManager getWorkflowManager() {
        return ComponentAccessor.getComponentOfType(WorkflowManager.class);
    }

    private static I18nHelper getI18nBean() {
        return WorkflowUtil.getAuthenticationContext().getI18nHelper();
    }

    public static String getWorkflowTransitionDisplayName(ActionDescriptor descriptor) {
        if (descriptor == null) {
            return WorkflowUtil.getI18nBean().getText("common.words.unknown");
        }
        Map metadata = descriptor.getMetaAttributes();
        if (metadata.containsKey("jira.i18n.title")) {
            String key = (String)metadata.get("jira.i18n.title");
            String value = WorkflowUtil.getI18nBean().getText(key);
            if (value != null && !"".equals(value.trim()) && !value.trim().equals(key.trim())) {
                return value;
            }
        }
        return descriptor.getName();
    }

    public static String getWorkflowTransitionDescription(ActionDescriptor descriptor) {
        return (String)descriptor.getMetaAttributes().get("jira.description");
    }

    @ExperimentalApi
    @Nonnull
    public static Integer getWorkflowTransitionOpsbarSequence(@Nullable ActionDescriptor action) {
        if (action == null) {
            return Integer.MAX_VALUE;
        }
        Map metaAttributes = action.getMetaAttributes();
        if (metaAttributes == null) {
            return Integer.MAX_VALUE;
        }
        String value = (String)metaAttributes.get("opsbar-sequence");
        if (value == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value) || !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)value)) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(value);
    }

    public static String getCallerKey(Map transientVars) {
        if (transientVars == null) {
            return null;
        }
        WorkflowContext context = (WorkflowContext)transientVars.get("context");
        if (context == null) {
            return null;
        }
        return context.getCaller();
    }

    public static ApplicationUser getCallerUser(Map transientVars) {
        return WorkflowFunctionUtils.getUserByKey(WorkflowUtil.getCallerKey(transientVars));
    }

    public static void setActionScreen(@Nonnull ActionDescriptor actionDescriptor, @Nullable FieldScreen screen) {
        if (screen == null) {
            actionDescriptor.setView(null);
            actionDescriptor.getMetaAttributes().put("jira.fieldscreen.id", null);
        } else {
            actionDescriptor.setView("fieldscreen");
            actionDescriptor.getMetaAttributes().put("jira.fieldscreen.id", screen.getId().toString());
        }
    }
}

