/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.comment;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.issue.visibility.Visibilities;
import com.atlassian.jira.bc.issue.visibility.Visibility;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.json.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface CommentService {
    public CommentCreateValidationResult validateCommentCreate(ApplicationUser var1, @Nonnull CommentParameters var2);

    public Comment create(ApplicationUser var1, CommentCreateValidationResult var2, boolean var3);

    @Deprecated
    public Comment create(ApplicationUser var1, Issue var2, String var3, String var4, Long var5, Date var6, boolean var7, ErrorCollection var8);

    @Deprecated
    public Comment create(ApplicationUser var1, Issue var2, String var3, String var4, Long var5, boolean var6, ErrorCollection var7);

    @Deprecated
    public Comment create(ApplicationUser var1, Issue var2, String var3, boolean var4, ErrorCollection var5);

    @Deprecated
    public void validateCommentUpdate(ApplicationUser var1, Long var2, String var3, String var4, Long var5, ErrorCollection var6);

    public CommentUpdateValidationResult validateCommentUpdate(ApplicationUser var1, Long var2, CommentParameters var3);

    @Deprecated
    public void update(ApplicationUser var1, MutableComment var2, boolean var3, ErrorCollection var4);

    public void update(ApplicationUser var1, CommentUpdateValidationResult var2, boolean var3);

    @Nonnull
    public List<Comment> getCommentsForUser(@Nullable ApplicationUser var1, @Nonnull Issue var2);

    @Deprecated
    public List<Comment> getCommentsForUser(ApplicationUser var1, Issue var2, ErrorCollection var3);

    @Nonnull
    public List<Comment> getCommentsForUserSince(@Nullable ApplicationUser var1, @Nonnull Issue var2, @Nonnull Date var3);

    public boolean hasPermissionToCreate(ApplicationUser var1, Issue var2, ErrorCollection var3);

    @Deprecated
    public boolean hasPermissionToEdit(ApplicationUser var1, Comment var2, ErrorCollection var3);

    public boolean isValidCommentBody(String var1, ErrorCollection var2);

    public boolean isValidCommentBody(String var1, ErrorCollection var2, boolean var3);

    @Deprecated
    public boolean isValidCommentData(ApplicationUser var1, Issue var2, String var3, String var4, ErrorCollection var5);

    public boolean isValidCommentVisibility(ApplicationUser var1, Issue var2, Visibility var3, ErrorCollection var4);

    @Deprecated
    public boolean isValidAllCommentData(ApplicationUser var1, Issue var2, String var3, String var4, String var5, ErrorCollection var6);

    public boolean isValidAllCommentData(ApplicationUser var1, Issue var2, String var3, Visibility var4, ErrorCollection var5);

    @Deprecated
    public boolean isGroupVisiblityEnabled();

    @Deprecated
    public boolean isProjectRoleVisiblityEnabled();

    public boolean isGroupVisibilityEnabled();

    public boolean isProjectRoleVisibilityEnabled();

    public Comment getCommentById(ApplicationUser var1, Long var2, ErrorCollection var3);

    public MutableComment getMutableComment(ApplicationUser var1, Long var2, ErrorCollection var3);

    public boolean hasPermissionToDelete(JiraServiceContext var1, Long var2);

    public boolean hasPermissionToEdit(JiraServiceContext var1, Long var2);

    public void delete(JiraServiceContext var1, Comment var2, boolean var3);

    public static final class CommentParameters {
        private final String body;
        private final String groupLevel;
        private final Long roleLevelId;
        private final Visibility visibility;
        private final Date created;
        private final ApplicationUser author;
        private final Issue issue;
        private final Map<String, JSONObject> commentProperties;

        private CommentParameters(String body, String groupLevel, Long roleLevelId, Visibility visibility, Date created, ApplicationUser author, Issue issue, Map<String, JSONObject> commentProperties) {
            this.body = body;
            this.groupLevel = groupLevel;
            this.roleLevelId = roleLevelId;
            this.visibility = visibility;
            this.created = created;
            this.author = author;
            this.issue = issue;
            this.commentProperties = commentProperties;
        }

        public static CommentParametersBuilder builder() {
            return new CommentParametersBuilder();
        }

        public static CommentParametersBuilder builder(Comment comment) {
            return new CommentParametersBuilder().author(comment.getAuthorApplicationUser()).body(comment.getBody()).groupLevel(comment.getGroupLevel()).roleLevelId(comment.getRoleLevelId()).issue(comment.getIssue()).created(comment.getCreated());
        }

        public String getBody() {
            return this.body;
        }

        @Deprecated
        public String getGroupLevel() {
            return this.groupLevel;
        }

        @Deprecated
        public Long getRoleLevelId() {
            return this.roleLevelId;
        }

        public Date getCreated() {
            return this.created;
        }

        public ApplicationUser getAuthor() {
            return this.author;
        }

        public Issue getIssue() {
            return this.issue;
        }

        @Nonnull
        public Map<String, JSONObject> getCommentProperties() {
            return this.commentProperties;
        }

        public Visibility getVisibility() {
            return this.visibility;
        }

        public static class CommentParametersBuilder {
            private String body;
            private String groupLevel;
            private Long roleLevelId;
            private Visibility visibility;
            private Date created;
            private ApplicationUser author;
            private Issue issue;
            private Map<String, JSONObject> commentProperties = new HashMap<String, JSONObject>();

            public CommentParametersBuilder body(String body) {
                this.body = body;
                return this;
            }

            public CommentParametersBuilder issue(Issue issue) {
                this.issue = issue;
                return this;
            }

            @Deprecated
            public CommentParametersBuilder groupLevel(String groupLevel) {
                this.groupLevel = groupLevel;
                return this;
            }

            @Deprecated
            public CommentParametersBuilder roleLevelId(Long roleLevelId) {
                this.roleLevelId = roleLevelId;
                return this;
            }

            public CommentParametersBuilder visibility(Visibility visibility) {
                this.visibility = visibility;
                return this;
            }

            public CommentParametersBuilder created(Date created) {
                this.created = created;
                return this;
            }

            public CommentParametersBuilder author(ApplicationUser author) {
                this.author = author;
                return this;
            }

            public CommentParametersBuilder commentProperties(Map<String, JSONObject> commentProperties) {
                this.commentProperties.putAll(commentProperties);
                return this;
            }

            public CommentParameters build() {
                if (this.visibility == null) {
                    this.visibility = Visibilities.fromGroupAndRoleId(this.groupLevel, this.roleLevelId);
                }
                return new CommentParameters(this.body, this.groupLevel, this.roleLevelId, this.visibility, this.created, this.author, this.issue, this.commentProperties);
            }
        }
    }

    public static final class CommentVisibility {
        private final String groupLevel;
        private final Long roleLevelId;

        public CommentVisibility(String groupLevel, Long roleLevelId) {
            this.groupLevel = groupLevel;
            this.roleLevelId = roleLevelId;
        }

        public String getGroupLevel() {
            return this.groupLevel;
        }

        public Long getRoleLevelId() {
            return this.roleLevelId;
        }
    }

    public static final class CommentUpdateValidationResult
    extends ServiceResultImpl {
        private final Option<Comment> comment;
        private final Option<Map<String, JSONObject>> commentProperties;

        public CommentUpdateValidationResult(SimpleErrorCollection errorCollection, Option<Map<String, JSONObject>> commentProperties, Option<Comment> comment) {
            super(errorCollection);
            this.commentProperties = commentProperties;
            this.comment = comment;
        }

        public Option<Comment> getComment() {
            return this.comment;
        }

        public Option<Map<String, JSONObject>> getCommentProperties() {
            return this.commentProperties;
        }
    }

    public static final class CommentCreateValidationResult
    extends ServiceResultImpl {
        private final Option<CommentParameters> commentInputParameters;

        public CommentCreateValidationResult(ErrorCollection errorCollection, Option<CommentParameters> commentInputParameters) {
            super(errorCollection);
            this.commentInputParameters = commentInputParameters;
        }

        public Option<CommentParameters> getCommentInputParameters() {
            return this.commentInputParameters;
        }
    }
}

