/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang.StringUtils;

@NotThreadSafe
public class UserCachingComparator
implements Comparator<ApplicationUser> {
    private final Collator collator;
    private final Map<String, CollationKey> collationKeys = new HashMap<String, CollationKey>(4096);

    public UserCachingComparator(Locale locale) {
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(1);
    }

    public UserCachingComparator() {
        this(Locale.getDefault());
    }

    @Override
    public int compare(ApplicationUser user1, ApplicationUser user2) {
        if (user1 == user2) {
            return 0;
        }
        if (user2 == null) {
            return -1;
        }
        if (user1 == null) {
            return 1;
        }
        int fullNameComparison = this.getKey(user1).compareTo(this.getKey(user2));
        if (fullNameComparison == 0) {
            return this.collator.compare(user1.getName(), user2.getName());
        }
        return fullNameComparison;
    }

    private CollationKey getKey(ApplicationUser user) {
        CollationKey collationKey = this.collationKeys.get(user.getName());
        if (collationKey == null) {
            String name = user.getDisplayName();
            if (StringUtils.isBlank((String)name)) {
                name = Assertions.notNull("user.getName()", user.getName());
            }
            collationKey = this.collator.getCollationKey(name);
            this.collationKeys.put(user.getName(), collationKey);
        }
        return collationKey;
    }
}

