/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import java.util.Objects;
import javax.annotation.Nonnull;

@PublicApi
public interface SearchService {
    public SearchResults search(ApplicationUser var1, Query var2, PagerFilter var3) throws SearchException;

    public SearchResults searchOverrideSecurity(ApplicationUser var1, Query var2, PagerFilter var3) throws SearchException;

    public long searchCount(ApplicationUser var1, Query var2) throws SearchException;

    public long searchCountOverrideSecurity(ApplicationUser var1, Query var2) throws SearchException;

    public String getQueryString(ApplicationUser var1, Query var2);

    @Nonnull
    public String getIssueSearchPath(ApplicationUser var1, @Nonnull IssueSearchParameters var2);

    public ParseResult parseQuery(ApplicationUser var1, String var2);

    @Nonnull
    public MessageSet validateQuery(ApplicationUser var1, @Nonnull Query var2);

    @Nonnull
    public MessageSet validateQuery(ApplicationUser var1, @Nonnull Query var2, Long var3);

    public boolean doesQueryFitFilterForm(ApplicationUser var1, Query var2);

    public QueryContext getQueryContext(ApplicationUser var1, Query var2);

    public QueryContext getSimpleQueryContext(ApplicationUser var1, Query var2);

    public SearchContext getSearchContext(ApplicationUser var1, Query var2);

    public String getJqlString(Query var1);

    public String getGeneratedJqlString(Query var1);

    public Query sanitiseSearchQuery(ApplicationUser var1, Query var2);

    @PublicApi
    public static final class IssueSearchParameters {
        private final Query query;
        private final Long filterId;

        private IssueSearchParameters(Query query, Long filterId) {
            this.query = query;
            this.filterId = filterId;
        }

        public Query query() {
            return this.query;
        }

        public Long filterId() {
            return this.filterId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueSearchParameters that = (IssueSearchParameters)o;
            return Objects.equals(this.query, that.query) && Objects.equals(this.filterId, that.filterId);
        }

        public int hashCode() {
            return Objects.hash(this.query, this.filterId);
        }

        public static class Builder {
            private Query query;
            private Long filterId;

            public Builder query(Query query) {
                this.query = query;
                return this;
            }

            public Builder filterId(Long filterId) {
                this.filterId = filterId;
                return this;
            }

            public IssueSearchParameters build() {
                return new IssueSearchParameters(this.query, this.filterId);
            }
        }
    }

    @PublicApi
    public static final class ParseResult {
        private Query query;
        private MessageSet errors;

        public ParseResult(Query query, MessageSet errors) {
            this.query = query;
            this.errors = Assertions.notNull("errors", errors);
        }

        public Query getQuery() {
            return this.query;
        }

        public MessageSet getErrors() {
            return this.errors;
        }

        public boolean isValid() {
            return !this.errors.hasAnyErrors();
        }
    }
}

