/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity.property;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.entity.property.EntityPropertyConditionHelper;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.plugin.webfragment.JiraWebContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Optional;

@PublicApi
public abstract class AbstractEntityPropertyConditionHelper<T extends WithId>
implements EntityPropertyConditionHelper {
    private final EntityPropertyService<T> propertyService;
    private final Class<T> propertyEntityType;
    private final String entityName;

    protected AbstractEntityPropertyConditionHelper(EntityPropertyService<T> propertyService, Class<T> propertyEntityType, String entityName) {
        this.propertyService = propertyService;
        this.propertyEntityType = propertyEntityType;
        this.entityName = entityName;
    }

    @Override
    public Optional<Long> getEntityId(JiraWebContext context) {
        return context.get(this.entityName, this.propertyEntityType).map(WithId::getId);
    }

    @Override
    public final String getEntityName() {
        return this.entityName;
    }

    @Override
    public final EntityPropertyService.PropertyResult getProperty(ApplicationUser user, Long entityId, String propertyKey) {
        return this.propertyService.getProperty(user, entityId, propertyKey);
    }
}

