/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinkJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueRefJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class IssueLinksBeanBuilder {
    private final ApplicationProperties applicationProperties;
    private final IssueLinkManager issueLinkManager;
    private final JiraAuthenticationContext authContext;
    private final JiraBaseUrls jiraBaseUrls;
    private final Issue issue;

    public IssueLinksBeanBuilder(ApplicationProperties applicationProperties, IssueLinkManager issueLinkManager, JiraAuthenticationContext authContext, JiraBaseUrls jiraBaseUrls, Issue issue) {
        this.applicationProperties = applicationProperties;
        this.issueLinkManager = issueLinkManager;
        this.authContext = authContext;
        this.jiraBaseUrls = jiraBaseUrls;
        this.issue = issue;
    }

    public List<IssueLinkJsonBean> buildIssueLinks() {
        if (!this.applicationProperties.getOption("jira.option.issuelinking")) {
            return null;
        }
        ArrayList linkBeans = Lists.newArrayList();
        LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(this.issue, this.authContext.getUser());
        Set<IssueLinkType> linkTypes = linkCollection.getLinkTypes();
        if (linkTypes != null) {
            for (IssueLinkType issueLinkType : linkTypes) {
                List<Issue> inwardIssues;
                List<Issue> outwardIssues = linkCollection.getOutwardIssues(issueLinkType.getName());
                if (outwardIssues != null) {
                    for (Issue outwardIssue : outwardIssues) {
                        IssueLink issueLink = this.issueLinkManager.getIssueLink(this.issue.getId(), outwardIssue.getId(), issueLinkType.getId());
                        linkBeans.add(this.buildLink(issueLinkType, outwardIssue, true, issueLink.getId().toString()));
                    }
                }
                if ((inwardIssues = linkCollection.getInwardIssues(issueLinkType.getName())) == null) continue;
                for (Issue inwardIssue : inwardIssues) {
                    IssueLink issueLink = this.issueLinkManager.getIssueLink(inwardIssue.getId(), this.issue.getId(), issueLinkType.getId());
                    linkBeans.add(this.buildLink(issueLinkType, inwardIssue, false, issueLink.getId().toString()));
                }
            }
        }
        return linkBeans;
    }

    public IssueLinkJsonBean buildLink(IssueLinkType issueLinkType, Issue issue, boolean isOutbound, String id) {
        IssueLinkBeanBuilder issueLinkBeanBuilder = new IssueLinkBeanBuilder(this.jiraBaseUrls);
        IssueLinkJsonBean issueLinkJsonBean = issueLinkBeanBuilder.buildIssueLinkBean(issueLinkType, id);
        return isOutbound ? issueLinkJsonBean.outwardIssue(issueLinkBeanBuilder.createIssueRefJsonBean(issue)) : issueLinkJsonBean.inwardIssue(issueLinkBeanBuilder.createIssueRefJsonBean(issue));
    }

    public IssueRefJsonBean buildParentLink() {
        Issue parent = this.issue.getParentObject();
        if (parent == null) {
            return null;
        }
        IssueLinkBeanBuilder issueLinkBeanBuilder = new IssueLinkBeanBuilder(this.jiraBaseUrls);
        return issueLinkBeanBuilder.createIssueRefJsonBean(parent);
    }

    public List<IssueRefJsonBean> buildSubtaskLinks() {
        Collection<Issue> subtasks = this.issue.getSubTaskObjects();
        if (subtasks == null) {
            return Collections.emptyList();
        }
        IssueLinkBeanBuilder issueLinkBeanBuilder = new IssueLinkBeanBuilder(this.jiraBaseUrls);
        ArrayList subtaskLinks = Lists.newArrayListWithCapacity((int)subtasks.size());
        for (Issue subtask : subtasks) {
            subtaskLinks.add(issueLinkBeanBuilder.createIssueRefJsonBean(subtask));
        }
        return subtaskLinks;
    }
}

