/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.codehaus.jackson.annotate.JsonProperty;

public class VotesJsonBean {
    @JsonProperty
    private String self;
    @JsonProperty
    private long votes;
    private boolean hasVoted;
    @JsonProperty
    private Collection<UserJsonBean> voters;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public long getVotes() {
        return this.votes;
    }

    public void setVotes(long votes) {
        this.votes = votes;
    }

    public boolean isHasVoted() {
        return this.hasVoted;
    }

    public void setHasVoted(boolean hasVoted) {
        this.hasVoted = hasVoted;
    }

    public Collection<UserJsonBean> getVoters() {
        return this.voters;
    }

    public void setVoters(Collection<UserJsonBean> voters) {
        this.voters = voters;
    }

    public static VotesJsonBean shortBean(String issueKey, long votes, boolean hasVoted, JiraBaseUrls urls) {
        VotesJsonBean bean = new VotesJsonBean();
        bean.self = urls.restApi2BaseUrl() + "issue/" + issueKey + "/votes";
        bean.hasVoted = hasVoted;
        bean.votes = votes;
        return bean;
    }

    @Deprecated
    public static VotesJsonBean fullBean(String issueKey, long votes, boolean hasVoted, Collection<ApplicationUser> voters, JiraBaseUrls urls) {
        return VotesJsonBean.fullBean(issueKey, votes, hasVoted, voters, urls, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public static VotesJsonBean fullBean(String issueKey, long votes, boolean hasVoted, Collection<ApplicationUser> voters, JiraBaseUrls urls, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        VotesJsonBean bean = VotesJsonBean.shortBean(issueKey, votes, hasVoted, urls);
        ArrayList result = Lists.newArrayListWithCapacity((int)voters.size());
        TimeZoneManager timeZoneManager = ComponentAccessor.getComponent(TimeZoneManager.class);
        UserBeanFactory userBeanFactory = ComponentAccessor.getComponent(UserBeanFactory.class);
        for (ApplicationUser from : voters) {
            result.add(userBeanFactory.createBean(from, loggedInUser, urls, emailFormatter, timeZoneManager));
        }
        bean.voters = result;
        return bean;
    }
}

