/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.information;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class GenericSearcherInformation<T extends SearchableField>
implements SearcherInformation<T> {
    private final String id;
    private final String nameKey;
    private final List<Class<? extends FieldIndexer>> indexers;
    private final AtomicReference<T> fieldReference;
    private final SearcherGroupType searcherGroupType;

    public GenericSearcherInformation(String id, String nameKey, List<Class<? extends FieldIndexer>> indexers, AtomicReference<T> fieldReference, SearcherGroupType searcherGroupType) {
        this.id = Assertions.notBlank("id", id);
        this.nameKey = Assertions.notBlank("nameKey", nameKey);
        this.indexers = Assertions.containsNoNulls("indexers", indexers);
        this.fieldReference = Assertions.notNull("fieldReference", fieldReference);
        this.searcherGroupType = Assertions.notNull("searcherGroupType", searcherGroupType);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getNameKey() {
        return this.nameKey;
    }

    @Override
    public List<FieldIndexer> getRelatedIndexers() {
        ArrayList<FieldIndexer> relatedIndexers = new ArrayList<FieldIndexer>();
        for (Class<? extends FieldIndexer> clazz : this.indexers) {
            relatedIndexers.add(this.loadIndexer(clazz));
        }
        return relatedIndexers;
    }

    @Override
    public SearcherGroupType getSearcherGroupType() {
        return this.searcherGroupType;
    }

    @Override
    public T getField() {
        return (T)((SearchableField)this.fieldReference.get());
    }

    FieldIndexer loadIndexer(Class<? extends FieldIndexer> clazz) {
        try {
            return (FieldIndexer)ComponentAccessor.getComponent(ComponentClassManager.class).newInstance(clazz.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load indexer '" + clazz.getName() + "'", e);
        }
    }
}

