/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.RangeQueryFactory;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.util.Function;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateRelationalQueryFactory
implements OperatorSpecificQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(LocalDateRelationalQueryFactory.class);
    private final RangeQueryFactory<LocalDate> rangeQueryFactory;
    private final JqlLocalDateSupport jqlLocalDateSupport;

    public LocalDateRelationalQueryFactory(final JqlLocalDateSupport jqlLocalDateSupport) {
        this.jqlLocalDateSupport = jqlLocalDateSupport;
        this.rangeQueryFactory = new RangeQueryFactory<LocalDate>(new Function<LocalDate, String>(){

            @Override
            public String get(LocalDate date) {
                return jqlLocalDateSupport.getIndexedValue(date);
            }
        });
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesSingleValueOperator(operator)) {
            log.debug(String.format("LocalDate operands do not support operator '%s'.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<LocalDate> dates = this.jqlLocalDateSupport.getLocalDatesFromQueryLiterals(rawValues);
        if (dates.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        LocalDate value = dates.get(0);
        if (value == null) {
            return QueryFactoryResult.createFalseResult();
        }
        return new QueryFactoryResult(this.rangeQueryFactory.get(operator, fieldName, value));
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesMultiValueOperator(operator)) {
            log.debug(String.format("LocalDate operands do not support operator '%s'.", operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        List<LocalDate> dates = this.jqlLocalDateSupport.getLocalDatesFromQueryLiterals(rawValues);
        ImmutableList filteredDates = ImmutableList.copyOf((Iterable)Iterables.filter(dates, (Predicate)new Predicate<LocalDate>(){

            public boolean apply(@Nullable LocalDate localDate) {
                return localDate != null;
            }
        }));
        if (filteredDates.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        return new QueryFactoryResult(this.rangeQueryFactory.get(operator, fieldName, (List<LocalDate>)filteredDates));
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        log.debug("Empty operands are not supported by this query factory.");
        return QueryFactoryResult.createFalseResult();
    }

    private boolean handlesSingleValueOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }

    private boolean handlesMultiValueOperator(Operator operator) {
        return operator == Operator.DURING;
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return this.handlesSingleValueOperator(operator) || this.handlesMultiValueOperator(operator);
    }
}

