/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.annotations.PublicApi;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface LicenseDetails {
    public int getLicenseVersion();

    public boolean isEntitledToSupport();

    @Deprecated
    public boolean isLicenseAlmostExpired();

    public JiraLicense getJiraLicense();

    @Nonnull
    public LicensedApplications getLicensedApplications();

    public boolean hasApplication(@Nonnull ApplicationKey var1);

    public LicenseStatusMessage getLicenseStatusMessage(I18nHelper var1, UserManager var2);

    public LicenseStatusMessage getMaintenanceMessage(@Nonnull I18nHelper var1, String var2);

    @Deprecated
    public String getLicenseStatusMessage(@Nullable ApplicationUser var1, String var2, UserManager var3);

    @Deprecated
    public String getLicenseStatusMessage(I18nHelper var1, @Nullable OutlookDate var2, String var3, UserManager var4);

    @Deprecated
    public String getLicenseExpiryStatusMessage(@Nullable ApplicationUser var1);

    @Deprecated
    public String getLicenseExpiryStatusMessage(I18nHelper var1, @Nullable OutlookDate var2);

    @Deprecated
    public String getBriefMaintenanceStatusMessage(I18nHelper var1);

    @Nullable
    public Date getMaintenanceExpiryDate();

    @Deprecated
    public String getMaintenanceEndString(OutlookDate var1);

    @Deprecated
    public boolean isUnlimitedNumberOfUsers();

    public String getDescription();

    public String getPartnerName();

    public boolean isExpired();

    @Deprecated
    public String getPurchaseDate(OutlookDate var1);

    default public String getPurchaseDate(DateTimeFormatter dateTimeFormatter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isEvaluation();

    public boolean isStarter();

    public boolean isPaidType();

    public boolean isCommercial();

    public boolean isPersonalLicense();

    public boolean isCommunity();

    public boolean isOpenSource();

    public boolean isNonProfit();

    public boolean isDemonstration();

    public boolean isOnDemand();

    public boolean isDataCenter();

    public boolean isDeveloper();

    public String getOrganisation();

    public String getLicenseString();

    public boolean isMaintenanceValidForBuildDate(Date var1);

    public String getSupportEntitlementNumber();

    public Collection<LicenseContact> getContacts();

    public boolean isEnterpriseLicenseAgreement();

    public int getDaysToLicenseExpiry();

    public int getDaysToMaintenanceExpiry();

    public LicenseType getLicenseType();

    @Nonnull
    public String getApplicationDescription();

    public static interface LicenseContact {
        public String getName();

        public String getEmail();
    }

    public static interface LicenseStatusMessage {
        public String getAllMessages(String var1);

        public Map<String, String> getAllMessages();

        public boolean hasMessageOfType(String var1);

        public boolean hasAnyMessages();
    }
}

