/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public final class CollectionBuilder<T> {
    private static final Ordering<?> NATURAL_ORDER = new NaturalOrdering();
    private final List<T> elements = new LinkedList<T>();

    public static <T> CollectionBuilder<T> newBuilder() {
        return new CollectionBuilder(Collections.emptyList());
    }

    public static <T> CollectionBuilder<T> newBuilder(T ... elements) {
        return new CollectionBuilder<T>(Arrays.asList(elements));
    }

    public static <T> List<T> list(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    static <T> Comparator<T> natural() {
        Ordering<?> result = NATURAL_ORDER;
        return result;
    }

    CollectionBuilder(Collection<? extends T> initialElements) {
        this.elements.addAll(initialElements);
    }

    public CollectionBuilder<T> add(T element) {
        this.elements.add(element);
        return this;
    }

    public <E extends T> CollectionBuilder<T> addAll(E ... elements) {
        this.elements.addAll(Arrays.asList(Assertions.notNull("elements", elements)));
        return this;
    }

    public CollectionBuilder<T> addAll(Collection<? extends T> elements) {
        this.elements.addAll(Assertions.notNull("elements", elements));
        return this;
    }

    public CollectionBuilder<T> addAll(Enumeration<? extends T> elements) {
        this.elements.addAll(CollectionUtil.toList(Assertions.notNull("elements", elements)));
        return this;
    }

    public Collection<T> asCollection() {
        return this.asList();
    }

    public Collection<T> asMutableCollection() {
        return this.asMutableList();
    }

    public List<T> asArrayList() {
        return new ArrayList<T>(this.elements);
    }

    public List<T> asLinkedList() {
        return new LinkedList<T>(this.elements);
    }

    public List<T> asList() {
        return Collections.unmodifiableList(new ArrayList<T>(this.elements));
    }

    public List<T> asMutableList() {
        return this.asArrayList();
    }

    public Set<T> asHashSet() {
        return new HashSet<T>(this.elements);
    }

    public Set<T> asListOrderedSet() {
        return new LinkedHashSet<T>(this.elements);
    }

    public Set<T> asImmutableListOrderedSet() {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(this.elements));
    }

    public Set<T> asSet() {
        return Collections.unmodifiableSet(new HashSet<T>(this.elements));
    }

    public Set<T> asMutableSet() {
        return this.asHashSet();
    }

    public SortedSet<T> asTreeSet() {
        return new TreeSet<T>(this.elements);
    }

    public SortedSet<T> asSortedSet() {
        return Collections.unmodifiableSortedSet(new TreeSet<T>(this.elements));
    }

    public SortedSet<T> asSortedSet(Comparator<? super T> comparator) {
        TreeSet<T> result = new TreeSet<T>(comparator);
        result.addAll(this.elements);
        return Collections.unmodifiableSortedSet(result);
    }

    public SortedSet<T> asMutableSortedSet() {
        return this.asTreeSet();
    }

    public EnclosedIterable<T> asEnclosedIterable() {
        return CollectionEnclosedIterable.copy(this.elements);
    }

    static class NaturalOrdering
    extends Ordering<Comparable>
    implements Serializable {
        private static final long serialVersionUID = 0L;

        NaturalOrdering() {
        }

        public int compare(Comparable left, Comparable right) {
            Assertions.notNull("right", right);
            if (left == right) {
                return 0;
            }
            return left.compareTo(right);
        }

        private Object readResolve() {
            return NATURAL_ORDER;
        }

        public String toString() {
            return "Ordering.natural()";
        }
    }
}

