/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public enum ProjectAction {
    VIEW_PROJECT(new int[]{0, 10, 23}, true, "admin.errors.project.no.view.permission"),
    VIEW_ARCHIVED_PROJECT(new int[]{0, 10, 23}, false, "admin.errors.project.no.view.permission"),
    VIEW_ISSUES(new int[]{10}, false, "admin.errors.project.no.browse.permission"),
    EDIT_PROJECT_CONFIG(new int[]{0, 23}, true, "admin.errors.project.no.config.permission"),
    VIEW_PROJECT_CONFIG(new int[]{0, 23}, false, "admin.errors.project.no.config.permission"),
    ARCHIVE_PROJECT(new int[]{0}, false, "admin.errors.project.no.archive.permission"),
    DELETE_PROJECT(new int[]{0, 23}, false, "admin.errors.project.no.delete.permission"),
    EDIT_PROJECT_KEY(new int[]{0}, true, "admin.projects.service.error.no.admin.permission.key"),
    EDIT_PROJECT_CONFIG_EXTENDED(ProjectAction::isExtendedProjectAdmin, true, "admin.errors.project.no.extended.config.permission");

    private final int[] permissions;
    private final String errorKey;
    private final Predicate<PredicateContext> permissionPredicate;
    private final boolean openProjectRequired;

    private ProjectAction(int[] permissions, boolean openProjectRequired, String errorKey) {
        this.permissions = permissions;
        this.errorKey = errorKey;
        this.permissionPredicate = null;
        this.openProjectRequired = openProjectRequired;
    }

    private ProjectAction(Predicate<PredicateContext> permissionPredicate, boolean openProjectRequired, String errorKey) {
        this.permissions = null;
        this.errorKey = errorKey;
        this.permissionPredicate = permissionPredicate;
        this.openProjectRequired = openProjectRequired;
    }

    int[] getPermissions() {
        return this.permissions;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public boolean hasPermissionPredicate() {
        return this.permissionPredicate != null;
    }

    public boolean hasPermission(PermissionManager permissionManager, ApplicationUser user, Project project) {
        PredicateContext predicateContext = new PredicateContext(permissionManager, user, project, ComponentAccessor.getPermissionSchemeManager());
        if (this.openProjectRequired && project.isArchived()) {
            return false;
        }
        if (this.hasPermissionPredicate()) {
            return this.permissionPredicate.test(predicateContext);
        }
        return this.checkPermissions(predicateContext);
    }

    private boolean checkPermissions(PredicateContext predicateContext) {
        for (int permission : this.permissions) {
            if (!(Permissions.isGlobalPermission(permission) ? predicateContext.getPermissionManager().hasPermission(permission, predicateContext.getUser()) : predicateContext.getPermissionManager().hasPermission(new ProjectPermissionKey(permission), predicateContext.getProject(), predicateContext.getUser()))) continue;
            return true;
        }
        return false;
    }

    static Boolean isExtendedProjectAdmin(@Nonnull PredicateContext context) {
        if (ProjectAction.isGlobalAdmin(context).booleanValue()) {
            return true;
        }
        return ProjectAction.isProjectAdmin(context) != false && context.getPermissionSchemeManager().hasExtendedProjectAdministration(context.getProject());
    }

    private static Boolean isGlobalAdmin(@Nonnull PredicateContext context) {
        return context.getPermissionManager().hasPermission(0, context.getUser());
    }

    private static Boolean isProjectAdmin(@Nonnull PredicateContext context) {
        return context.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, context.getProject(), context.getUser());
    }

    static class PredicateContext {
        private final PermissionManager permissionManager;
        private final ApplicationUser user;
        private final Project project;
        private final PermissionSchemeManager permissionSchemeManager;

        PredicateContext(PermissionManager manager, ApplicationUser user, Project project, PermissionSchemeManager permissionSchemeManager) {
            this.permissionManager = manager;
            this.user = user;
            this.project = project;
            this.permissionSchemeManager = permissionSchemeManager;
        }

        public PermissionManager getPermissionManager() {
            return this.permissionManager;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public Project getProject() {
            return this.project;
        }

        public PermissionSchemeManager getPermissionSchemeManager() {
            return this.permissionSchemeManager;
        }
    }
}

