/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class SortableTextCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField field;
    private final String sortFieldPrefix;

    public SortableTextCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, String sortFieldPrefix) {
        super(fieldVisibilityManager, Assertions.notNull("field", customField));
        this.sortFieldPrefix = Assertions.notBlank("sortFieldPrefix", sortFieldPrefix);
        this.field = customField;
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        String value = (String)this.field.getValue(issue);
        if (value != null) {
            if (searchable) {
                doc.add((IndexableField)new TextField(this.getDocumentFieldId(), value, Field.Store.YES));
                doc.add((IndexableField)new TextField(PhraseQuerySupportField.forIndexField(this.getDocumentFieldId()), value, Field.Store.YES));
            } else {
                doc.add((IndexableField)new StoredField(this.getDocumentFieldId(), value));
                doc.add((IndexableField)new StoredField(PhraseQuerySupportField.forIndexField(this.getDocumentFieldId()), value));
            }
        }
        if (searchable) {
            String valueForSorting = FieldIndexerUtil.getValueForSorting(value);
            doc.add((IndexableField)new SortedDocValuesField(this.sortFieldPrefix + this.getDocumentFieldId(), new BytesRef((CharSequence)valueForSorting)));
        }
    }
}

