/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(GenericClauseQueryFactory.class);
    private final JqlOperandResolver operandResolver;
    private final List<OperatorSpecificQueryFactory> operatorQueryFactories;
    private final String documentFieldName;

    public GenericClauseQueryFactory(String documentFieldName, List<OperatorSpecificQueryFactory> operatorQueryFactories, JqlOperandResolver operandResolver) {
        this.documentFieldName = Assertions.notNull("documentFieldName", documentFieldName);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.operatorQueryFactories = CollectionUtil.copyAsImmutableList((Collection)Assertions.notNull("operatorQueryFactories", operatorQueryFactories));
    }

    public GenericClauseQueryFactory(SimpleFieldSearchConstants constants, List<OperatorSpecificQueryFactory> operatorQueryFactories, JqlOperandResolver operandResolver) {
        this(constants.getIndexField(), operatorQueryFactories, operandResolver);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (this.operandResolver.isValidOperand(operand)) {
            for (OperatorSpecificQueryFactory operatorQueryFactory : this.operatorQueryFactories) {
                if (!operatorQueryFactory.handlesOperator(operator)) continue;
                if (this.operandResolver.isEmptyOperand(operand)) {
                    return operatorQueryFactory.createQueryForEmptyOperand(this.documentFieldName, operator);
                }
                List<QueryLiteral> rawValues = this.getRawValues(queryCreationContext, terminalClause);
                if (this.operandResolver.isListOperand(operand)) {
                    return operatorQueryFactory.createQueryForMultipleValues(this.documentFieldName, operator, rawValues);
                }
                return operatorQueryFactory.createQueryForSingleValue(this.documentFieldName, operator, rawValues);
            }
            log.debug(String.format("The '%s' clause does not support the %s operator.", terminalClause.getName(), operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        log.debug(String.format("There is no OperandHandler registered to handle the operand '%s' for operand '%s'.", operator.getDisplayString(), terminalClause.getOperand().getDisplayString()));
        return QueryFactoryResult.createFalseResult();
    }

    List<QueryLiteral> getRawValues(QueryCreationContext queryCreationContext, TerminalClause clause) {
        return this.operandResolver.getValues(queryCreationContext, clause.getOperand(), clause);
    }
}

