/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.PathTraversalException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;

public class PathUtils {
    private PathUtils() {
    }

    public static String appendFileSeparator(String filePath) {
        return filePath == null ? null : (filePath.endsWith("/") || filePath.endsWith("\\") ? filePath : filePath + File.separator);
    }

    public static String joinPaths(String ... paths) {
        return StringUtils.join((Object[])paths, (String)File.separator);
    }

    public static void ensurePathInSecureDir(String secureDir, String untrustedPath) throws PathTraversalException, IOException {
        if (!PathUtils.isPathInSecureDir(secureDir, untrustedPath)) {
            throw new PathTraversalException();
        }
    }

    public static boolean isPathInSecureDir(String secureDir, String untrustedPath) throws IOException {
        return PathUtils.isPathInSecureDir(new File(secureDir), new File(untrustedPath));
    }

    public static boolean isPathInSecureDir(File secureDir, File untrustedPath) throws IOException {
        return PathUtils.isChildPath(secureDir, untrustedPath);
    }

    public static boolean isChildPath(File parentPath, File childPath) throws IOException {
        Path parentCanonicalPath = Paths.get(parentPath.getCanonicalPath(), new String[0]);
        Path childCanonicalPath = Paths.get(childPath.getCanonicalPath(), new String[0]);
        return childCanonicalPath.startsWith(parentCanonicalPath);
    }
}

