/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import java.util.EnumMap;
import java.util.Map;

class ProjectActionPermissionHelper {
    private static ProjectActionPermissionHelper INSTANCE = new ProjectActionPermissionHelper();
    private static final int[] ADMIN_PERMISSIONS = new int[]{0, 23};
    private static final int[] BROWSE_PERMISSION = new int[]{10};
    private static final int[] EMPTY_PERM = new int[0];
    private static final Map<ProjectAction, int[]> PARTIAL_PERMISSIONS;
    private static final Map<ProjectAction, int[]> PROJECT_WIDE_PERMISSIONS;
    private static Boolean isFeatureEnabled;

    private ProjectActionPermissionHelper() {
    }

    public static ProjectActionPermissionHelper getInstance() {
        return INSTANCE;
    }

    public int[] getPartialPermissions(ProjectAction action) {
        return this.isFixEnabled() ? PARTIAL_PERMISSIONS.getOrDefault((Object)action, action.getPermissions()) : action.getPermissions();
    }

    public int[] getProjectWidePermissions(ProjectAction action) {
        return this.isFixEnabled() ? PROJECT_WIDE_PERMISSIONS.getOrDefault((Object)action, EMPTY_PERM) : EMPTY_PERM;
    }

    public boolean checkPermissions(ProjectAction action, ProjectAction.PredicateContext predicateContext) {
        for (int permission : this.getPartialPermissions(action)) {
            if (!this.checkPartialPermissions(predicateContext, permission)) continue;
            return true;
        }
        for (int permission : this.getProjectWidePermissions(action)) {
            if (!this.checkProjectWidePermissions(predicateContext, permission)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPartialPermissions(ProjectAction.PredicateContext predicateContext, int permission) {
        if (Permissions.isGlobalPermission(permission)) {
            return predicateContext.getPermissionManager().hasPermission(permission, predicateContext.getUser());
        }
        return predicateContext.getPermissionManager().hasPermission(new ProjectPermissionKey(permission), predicateContext.getProject(), predicateContext.getUser());
    }

    private boolean checkProjectWidePermissions(ProjectAction.PredicateContext predicateContext, int permission) {
        return predicateContext.getPermissionManager().hasProjectWidePermission(new ProjectPermissionKey(permission), predicateContext.getProject(), predicateContext.getUser()).equals((Object)ProjectWidePermission.ALL_ISSUES);
    }

    boolean isFixEnabled() {
        if (isFeatureEnabled == null) {
            ApplicationProperties applicationProperties = ComponentAccessor.getComponentSafely(ApplicationProperties.class).orElse(null);
            if (applicationProperties != null) {
                isFeatureEnabled = applicationProperties.getOption("jira.project.permission.helper.beta.fix.enabled");
            } else {
                return false;
            }
        }
        return isFeatureEnabled;
    }

    static {
        isFeatureEnabled = null;
        PARTIAL_PERMISSIONS = new EnumMap<ProjectAction, int[]>(ProjectAction.class);
        PARTIAL_PERMISSIONS.put(ProjectAction.VIEW_PROJECT, ADMIN_PERMISSIONS);
        PARTIAL_PERMISSIONS.put(ProjectAction.VIEW_ARCHIVED_PROJECT, ADMIN_PERMISSIONS);
        PROJECT_WIDE_PERMISSIONS = new EnumMap<ProjectAction, int[]>(ProjectAction.class);
        PROJECT_WIDE_PERMISSIONS.put(ProjectAction.VIEW_PROJECT, BROWSE_PERMISSION);
        PROJECT_WIDE_PERMISSIONS.put(ProjectAction.VIEW_ARCHIVED_PROJECT, BROWSE_PERMISSION);
    }
}

