/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.customfield;

import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCustomFieldImporter
implements ProjectCustomFieldImporter {
    private static final Logger log = LoggerFactory.getLogger(VersionCustomFieldImporter.class);

    @Override
    public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
        return null;
    }

    @Override
    public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(@Nonnull ProjectImportMapper projectImportMapper, @Nonnull ExternalCustomFieldValue customFieldValue, @Nullable FieldConfig fieldConfig) {
        if (customFieldValue.getCustomFieldId() == null) {
            log.debug("The custom field id is not present in the backup file.");
            return new ProjectCustomFieldImporter.MappedCustomFieldValue(null);
        }
        if (customFieldValue.getValue() == null) {
            log.debug("The value for a custom field (name or id if name not found) {} is not present in the backup file.", (Object)projectImportMapper.getCustomFieldMapper().getDisplayName(customFieldValue.getCustomFieldId()));
            return new ProjectCustomFieldImporter.MappedCustomFieldValue(null);
        }
        String fieldValue = customFieldValue.getValue().replaceAll("[\\[\\]]", "");
        String oldVersionId = this.getNonDecimalValue(fieldValue);
        String mappedVersionId = projectImportMapper.getVersionMapper().getMappedId(oldVersionId);
        if (mappedVersionId == null) {
            log.warn("The version custom field (name or id if name not found) '{}' references a version with id '{}' that is an orphan value. The value will not be imported.", (Object)projectImportMapper.getCustomFieldMapper().getDisplayName(customFieldValue.getCustomFieldId()), (Object)oldVersionId);
        }
        return new ProjectCustomFieldImporter.MappedCustomFieldValue(mappedVersionId);
    }

    private String getNonDecimalValue(String value) {
        if (value != null) {
            return Long.toString(new Double(value).intValue());
        }
        return null;
    }
}

