/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.issue.AttachmentError;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Pair;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AttachmentsBulkOperationResult<T> {
    private final List<AttachmentError> errors;
    private final List<T> results;

    public AttachmentsBulkOperationResult(List<AttachmentError> errors, List<T> results) {
        this.errors = ImmutableList.copyOf(errors);
        this.results = ImmutableList.copyOf(results);
    }

    public AttachmentsBulkOperationResult(Pair<List<AttachmentError>, List<T>> errorAndResult) {
        this((List)errorAndResult.left(), (List)errorAndResult.right());
    }

    public List<AttachmentError> getErrors() {
        return this.errors;
    }

    public List<T> getResults() {
        return this.results;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.errors, this.results});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentsBulkOperationResult other = (AttachmentsBulkOperationResult)obj;
        return Objects.equal(this.errors, other.errors) && Objects.equal(this.results, other.results);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("errors", this.errors).add("results", this.results).toString();
    }
}

