/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.annotations.Internal;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.lang.Pair;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class DateSearchRendererViewHtmlMessageProvider {
    private static final Logger log = LoggerFactory.getLogger(DateSearchRendererViewHtmlMessageProvider.class);
    private final FieldValuesHolder fieldValuesHolder;
    private final DateSearcherConfig config;
    private final String searchNameKey;
    private final Object previousFieldValue;
    private final Object nextFieldValue;
    private final MessageResolver messageResolver;

    DateSearchRendererViewHtmlMessageProvider(I18nHelper i18n, FieldValuesHolder fieldValuesHolder, DateSearcherConfig config, String searchNameKey) {
        this(new I18HelperMessageResolver(i18n), fieldValuesHolder, config, searchNameKey);
    }

    DateSearchRendererViewHtmlMessageProvider(MessageResolver messageResolver, FieldValuesHolder fieldValuesHolder, DateSearcherConfig config, String searchNameKey) {
        this.messageResolver = messageResolver;
        this.fieldValuesHolder = fieldValuesHolder;
        this.config = config;
        this.searchNameKey = searchNameKey;
        this.previousFieldValue = fieldValuesHolder.get(config.getPreviousField());
        this.nextFieldValue = fieldValuesHolder.get(config.getNextField());
    }

    Result getResult() {
        if (this.previousFieldValue == null && this.nextFieldValue == null) {
            return null;
        }
        Pair<String, Long> previousValueAndOffset = this.valueAndOffSet(this.previousFieldValue, this.config.getPreviousField());
        Pair<String, Long> nextValueAndOffset = this.valueAndOffSet(this.nextFieldValue, this.config.getNextField());
        String previousValue = previousValueAndOffset.first();
        String nextValue = nextValueAndOffset.first();
        if (previousValue == null && nextValue == null) {
            return null;
        }
        Long previousPeriodOffSet = previousValueAndOffset.second();
        Long nextPeriodOffSet = nextValueAndOffset.second();
        if (previousValue != null && nextValue != null) {
            return new Result(this.getBothFieldsMessage(previousValue, nextValue, previousPeriodOffSet, nextPeriodOffSet), true, true);
        }
        if (previousValue != null) {
            return new Result(this.getPreviousFieldMessage(previousValue), true, false);
        }
        return new Result(this.getNextFieldMessage(nextValue, nextPeriodOffSet), false, true);
    }

    private Pair<String, Long> valueAndOffSet(Object fieldValue, String fieldName) {
        String value;
        Long offset;
        if (fieldValue != null) {
            offset = this.getPeriodOffset(fieldName);
            value = this.formatFieldValue(fieldValue, offset);
        } else {
            value = null;
            offset = null;
        }
        return Pair.nicePairOf(value, offset);
    }

    private Long getPeriodOffset(String paramField) {
        String periodStr;
        if (this.fieldValuesHolder.containsKey(paramField) && (periodStr = StringUtils.trimToNull((String)ParameterUtils.getStringParam(this.fieldValuesHolder, paramField))) != null) {
            try {
                return -DateUtils.getDurationWithNegative((String)periodStr) * DateUtils.SECOND_MILLIS;
            }
            catch (InvalidDurationException e) {
                log.debug("Could not get duration for: " + periodStr, (Throwable)e);
            }
            catch (NumberFormatException e) {
                log.debug("Could not get duration for: " + periodStr, (Throwable)e);
            }
        }
        return null;
    }

    private String formatFieldValue(Object fieldValue, Long periodOffSet) {
        if (periodOffSet == null) {
            String fieldStr = (String)fieldValue;
            if (fieldStr.startsWith("-")) {
                fieldStr = fieldStr.substring(1);
            }
            return StringEscapeUtils.escapeJava((String)fieldStr);
        }
        return this.prettyPrint(periodOffSet);
    }

    private String prettyPrint(long periodOffSet) {
        return this.messageResolver.prettyPrint((long)((double)Math.abs(periodOffSet) / 1000.0));
    }

    private String getBothFieldsMessage(String previousValue, String nextValue, long previousPeriodOffSet, long nextPeriodOffSet) {
        String nextFieldStr;
        if (previousPeriodOffSet > 0L) {
            if (nextPeriodOffSet > 0L) {
                return this.getText("navigator.filter.date.period.fromago.toago", previousValue, nextValue);
            }
            if (nextPeriodOffSet < 0L) {
                return this.getText("navigator.filter.date.period.fromago.tofromnow", previousValue, nextValue);
            }
            return this.getText("navigator.filter.date.period.fromago.tonow", previousValue);
        }
        if (previousPeriodOffSet < 0L) {
            return this.getText("navigator.filter.date.period.fromfromnow.tofromnow", previousValue, nextValue);
        }
        if (this.isDueDate() && !"0".equals(nextFieldStr = (String)this.nextFieldValue) && !nextFieldStr.startsWith("-")) {
            return this.getText("navigator.filter.date.duedate.dueinnext.overdue", nextValue);
        }
        if (nextPeriodOffSet < 0L) {
            return this.getText("navigator.filter.date.period.fromnow.tofromnow", nextValue);
        }
        return this.getText("navigator.filter.date.period.fromnow.tonow", new String[0]);
    }

    private String getPreviousFieldMessage(String previousValue) {
        return this.getText("navigator.filter.date.withinthelast", previousValue);
    }

    private String getNextFieldMessage(String nextValue, Long nextPeriodOffSet) {
        if (nextPeriodOffSet == null) {
            return this.getText("navigator.filter.date.morethan", nextValue);
        }
        if (this.isDueDate()) {
            String nextFieldStr = (String)this.nextFieldValue;
            if ("0".equals(nextFieldStr)) {
                return this.getText("navigator.filter.date.duedate.nowoverdue", new String[0]);
            }
            if (!nextFieldStr.startsWith("-")) {
                return this.getText("navigator.filter.date.duedate.dueinnext.only", nextValue);
            }
        }
        if (nextPeriodOffSet > 0L) {
            return this.getText("navigator.filter.date.morethanago", nextValue);
        }
        if (nextPeriodOffSet < 0L) {
            return this.getText("navigator.filter.date.morethanfromnow", nextValue);
        }
        return this.getText("navigator.filter.date.morethannow", new String[0]);
    }

    private boolean isDueDate() {
        return "navigator.filter.duedate".equals(this.searchNameKey);
    }

    private String getText(String key, String ... parameters) {
        return this.messageResolver.getText(key, parameters);
    }

    static class I18HelperMessageResolver
    implements MessageResolver {
        private final I18nHelper i18n;

        I18HelperMessageResolver(I18nHelper i18n) {
            this.i18n = i18n;
        }

        @Override
        public String getText(String key, String ... parameters) {
            return this.i18n.getText(key, parameters);
        }

        @Override
        public String prettyPrint(long periodOffSet) {
            return DateUtils.getDurationPretty((long)periodOffSet, (ResourceBundle)this.i18n.getResourceBundle());
        }
    }

    static interface MessageResolver {
        public String getText(String var1, String ... var2);

        public String prettyPrint(long var1);
    }

    static class Result {
        final String message;
        final boolean previous;
        final boolean next;

        private Result(String message, boolean previous, boolean next) {
            this.message = message;
            this.previous = previous;
            this.next = next;
        }
    }
}

