/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.admin;

import com.atlassian.jira.admin.TabLoadedDataProvider;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissionHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nullable;

public class DefaultTabLoadedDataProvider
implements TabLoadedDataProvider {
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectPermissionHelper projectPermissionHelper;

    public DefaultTabLoadedDataProvider(GlobalPermissionManager globalPermissionManager, ProjectPermissionHelper projectPermissionHelper) {
        this.globalPermissionManager = globalPermissionManager;
        this.projectPermissionHelper = projectPermissionHelper;
    }

    @Override
    public boolean isAdmin(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    @Override
    public boolean isSysAdmin(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }

    @Override
    public boolean hasExtPermission(@Nullable Project project) {
        return this.projectPermissionHelper.hasExtPermission(project);
    }
}

