/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity;

import com.atlassian.jira.appconsistency.integrity.IntegrityCheckManager;
import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.check.Check;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.task.context.Context;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrityChecker {
    private static final Logger log = LoggerFactory.getLogger(IntegrityChecker.class);
    private final IntegrityCheckManager integrityCheckManager;

    public IntegrityChecker(IntegrityCheckManager integrityCheckManager) {
        this.integrityCheckManager = integrityCheckManager;
    }

    public Map preview(List<Check> checks) throws IntegrityException {
        HashMap<Check, List> results = new HashMap<Check, List>();
        for (Check check : checks) {
            results.put(check, this.loggedPreview(check));
        }
        return results;
    }

    public Map previewWithIds(List<Long> checkIds) throws IntegrityException {
        HashMap<Check, List> results = new HashMap<Check, List>();
        for (Long checkId : checkIds) {
            Check check = this.integrityCheckManager.getCheck(checkId);
            results.put(check, this.loggedPreview(check));
        }
        return results;
    }

    public Map<Long, List<Amendment>> previewWithIdsWithProgress(List<Long> checkIds, Context taskContext) throws IntegrityException {
        HashMap<Long, List<Amendment>> results = new HashMap<Long, List<Amendment>>();
        for (Long checkId : checkIds) {
            if (checkId != null) {
                Check check = this.integrityCheckManager.getCheck(checkId);
                if (check != null) {
                    taskContext.setName(check.getDescription());
                    Context.Task task = taskContext.start((Object)check);
                    results.put(check.getId(), this.loggedPreview(check));
                    task.complete();
                    continue;
                }
                log.warn("Check with the checkId={} not found.", (Object)checkId);
                continue;
            }
            log.warn("CheckId shouldn't be a null value! Skipping.");
        }
        return results;
    }

    private List loggedPreview(Check check) throws IntegrityException {
        Stopwatch started = Stopwatch.createStarted();
        log.info("[INTEGRITY CHECK] Starting preview by integrity check: {}, id: {}", (Object)check.getDescription(), (Object)check.getId());
        List<Amendment> preview = this.preview(check);
        Multimap index = this.numberOfOccurrenceOfAmendmentType(preview);
        log.info("[INTEGRITY CHECK] Finished preview by integrity check: {}, id: {}. It took: {} seconds. Number of errors: {}. Number of unfixable errors: {}.", new Object[]{check.getDescription(), check.getId(), started.elapsed(TimeUnit.SECONDS), index.get((Object)2).size(), index.get((Object)1).size()});
        return preview;
    }

    public Map correct(List<Check> checks) throws IntegrityException {
        HashMap<Check, List> results = new HashMap<Check, List>();
        for (Check check : checks) {
            results.put(check, this.loggedCorrect(check));
        }
        return results;
    }

    public Map correctWithIds(List<Long> checkIds) throws IntegrityException {
        HashMap<Check, List> results = new HashMap<Check, List>();
        for (Long checkId : checkIds) {
            Check check = this.integrityCheckManager.getCheck(checkId);
            results.put(check, this.loggedCorrect(check));
        }
        return results;
    }

    public Map<Long, List<Amendment>> correctWithIdsWithProgress(List<Long> checkIds, Context taskContext) throws IntegrityException {
        HashMap<Long, List<Amendment>> results = new HashMap<Long, List<Amendment>>();
        for (Long checkId : checkIds) {
            if (checkId != null) {
                Check check = this.integrityCheckManager.getCheck(checkId);
                if (check != null) {
                    taskContext.setName(check.getDescription());
                    Context.Task task = taskContext.start((Object)check);
                    results.put(check.getId(), this.loggedCorrect(check));
                    task.complete();
                    continue;
                }
                log.warn("Check with the checkId={} not found.", (Object)checkId);
                continue;
            }
            log.warn("CheckId shouldn't be a null value! Skipping.");
        }
        return results;
    }

    private List loggedCorrect(Check check) throws IntegrityException {
        Stopwatch started = Stopwatch.createStarted();
        log.info("[INTEGRITY CHECK] Starting correction by integrity check: {}, id: {}", (Object)check.getDescription(), (Object)check.getId());
        List correct = this.correct(check);
        Multimap index = this.numberOfOccurrenceOfAmendmentType(correct);
        log.info("[INTEGRITY CHECK] Finished correction by integrity check: {}, id: {}. It took: {} seconds. Number of corrections: {}.", new Object[]{check.getDescription(), check.getId(), started.elapsed(TimeUnit.SECONDS), index.get((Object)0).size()});
        return correct;
    }

    private Multimap numberOfOccurrenceOfAmendmentType(List preview) {
        return Multimaps.index((Iterable)preview, IntegrityChecker::getAmendmentType);
    }

    private static Integer getAmendmentType(Amendment input) {
        if (input.isCorrection()) {
            return 0;
        }
        if (input.isWarning()) {
            return 1;
        }
        if (input.isError()) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    public List<Amendment> preview(Check check) throws IntegrityException {
        return check.preview();
    }

    public List correct(Check check) throws IntegrityException {
        return check.correct();
    }
}

