/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.amendment.CreateEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.AbstractEntityRelation;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class PrimaryEntityRelationCreate
extends AbstractEntityRelation {
    private final String relationField;
    private final Map fields;

    public PrimaryEntityRelationCreate(OfBizDelegator ofBizDelegator, QueryDslAccessor queryDslAccessor, int id, String relationType, String relationName, String relationField, Map fields) {
        super(ofBizDelegator, queryDslAccessor, id, relationType, relationName);
        this.relationField = relationField;
        this.fields = fields;
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.primary.entity.relation.desc", this.getEntityName(), this.getRelationType() + this.getRelationName());
    }

    protected Amendment previewAmendment(GenericValue entity) {
        return new CreateEntityAmendment(2, this.getI18NBean().getText("admin.integrity.check.primary.entity.relation.create.preview", this.getRelationType() + this.getRelationName(), this.getRelationName()), entity);
    }

    @Override
    public List correct() throws IntegrityException {
        ArrayList<GenericValue> toUpdate = new ArrayList<GenericValue>();
        ArrayList<CreateEntityAmendment> result = new ArrayList<CreateEntityAmendment>();
        try (OfBizListIterator allEntities = null;){
            allEntities = this.getEntities(this.getEntityName());
            GenericValue entity = allEntities.next();
            while (entity != null) {
                try {
                    GenericValue relatedEntity = entity.getRelatedOne(this.getRelationType() + this.getRelationName());
                    if (relatedEntity == null) {
                        GenericValue relation = EntityUtils.createValue(this.getRelationName(), new HashMap<String, Object>(this.getFields()));
                        entity.set(this.getRelationField(), relation.get("id"));
                        result.add(new CreateEntityAmendment(0, this.getI18NBean().getText("admin.integrity.check.primary.entity.relation.create.message", this.getRelationName()), entity));
                        toUpdate.add(entity);
                    }
                }
                catch (GenericEntityException e) {
                    throw new IntegrityException(e);
                }
                entity = allEntities.next();
            }
        }
        if (!toUpdate.isEmpty()) {
            try {
                this.ofBizDelegator.storeAll(toUpdate);
            }
            catch (Exception e) {
                throw new IntegrityException(e);
            }
        }
        return result;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private String getRelationField() {
        return this.relationField;
    }

    private Map getFields() {
        return this.fields;
    }
}

