/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.integritycheck;

import com.atlassian.jira.appconsistency.integrity.IntegrityChecker;
import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.appconsistency.integrity.integritycheck.ProgressAwareIntegrityCheckerOperation;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import java.util.Map;

public class CheckIntegrityOperation
implements ProgressAwareIntegrityCheckerOperation {
    public static final String RETURN_URL = "IntegrityChecker!preview.jspa";
    public static final String OPERATION_NAME_KEY = "admin.integritychecker.operation.progress.taskname.check";
    public static final String OPERATION_DESCRIPTION_KEY = "admin.integritychecker.check.operation.progress";
    private final IntegrityChecker integrityChecker;
    private final String operationName;
    private final String operationDescription;

    public CheckIntegrityOperation(I18nHelper i18nHelper, IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
        this.operationName = i18nHelper.getText(OPERATION_NAME_KEY);
        this.operationDescription = i18nHelper.getText(OPERATION_DESCRIPTION_KEY);
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public String getOperationDescription() {
        return this.operationDescription;
    }

    @Override
    public String getOperationProgressKey() {
        return OPERATION_DESCRIPTION_KEY;
    }

    @Override
    public Map<Long, List<Amendment>> perform(List<Long> checks, Context taskContext) throws IntegrityException {
        return this.integrityChecker.previewWithIdsWithProgress(checks, taskContext);
    }
}

