/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AssociatedItemImpl;
import com.atlassian.jira.auditing.AuditRecord;
import com.atlassian.jira.auditing.AuditRecordImpl;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingEntry;
import com.atlassian.jira.auditing.AuditingFilter;
import com.atlassian.jira.auditing.AuditingStore;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.atlassian.jira.auditing.Records;
import com.atlassian.jira.auditing.SearchTokenizer;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.entity.AbstractEntityFactory;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.SelectQuery;
import com.atlassian.jira.model.querydsl.AuditLogDTO;
import com.atlassian.jira.model.querydsl.QAuditItem;
import com.atlassian.jira.model.querydsl.QAuditLog;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Visitor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class AuditingStoreImpl
implements AuditingStore {
    public static final long OTHER = 0L;
    public static final long SYSADMIN = 1L;
    public static final int MAX_RESULTS_LIMIT = 10000;
    public static final String JIRA_INTERNAL_DIRECTORY_ID = "1";
    private static final String ENTITY_NAME = "AuditLog";
    private static final String ITEMS_ENTITY_NAME = "AuditItem";
    private static final String CHANGED_VALUES_ENTITY_NAME = "AuditChangedValue";
    private final OfBizDelegator ofBizDelegator;
    private final TransactionSupport transactionSupport;
    private final QueryDslAccessor queryDslAccessor;

    public AuditingStoreImpl(OfBizDelegator ofBizDelegator, TransactionSupport transactionSupport, QueryDslAccessor queryDslAccessor) {
        this.ofBizDelegator = ofBizDelegator;
        this.transactionSupport = transactionSupport;
        this.queryDslAccessor = queryDslAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeRecord(@Nonnull AuditingEntry entry) {
        Transaction transaction = this.transactionSupport.begin();
        try {
            HashMap values = Maps.newHashMap();
            values.put("remoteAddress", entry.remoteAddress());
            values.put("created", new Timestamp(System.currentTimeMillis()));
            ApplicationUser author = entry.author();
            values.put("authorKey", author != null ? author.getKey() : null);
            values.put("summary", entry.summaryI18nKey());
            values.put("category", entry.category().getId());
            values.put("authorType", entry.authorIsSysAdmin() ? 1L : 0L);
            values.put("eventSourceName", StringUtils.defaultString((String)entry.eventSource()));
            values.put("longDescription", StringUtils.defaultString((String)entry.description()));
            AssociatedItem objectItem = entry.objectItem();
            if (objectItem != null) {
                values.put("objectId", objectItem.getObjectId());
                values.put("objectName", objectItem.getObjectName());
                values.put("objectParentId", objectItem.getParentId());
                values.put("objectParentName", objectItem.getParentName());
                values.put("objectType", objectItem.getObjectType().toString());
            }
            Iterable<AssociatedItem> associatedItems = entry.associatedItems();
            Iterable<ChangedValue> changedValues = entry.changedValues();
            values.put("searchField", AuditingStoreImpl.computeSearchField(entry.summaryI18nKey(), objectItem, associatedItems, changedValues, entry.remoteAddress(), author, entry.categoryName(), entry.eventSource()));
            GenericValue gv = this.ofBizDelegator.createValue(ENTITY_NAME, (Map)values);
            if (associatedItems != null) {
                this.storeAssociatedItems(gv, associatedItems);
            }
            if (changedValues != null) {
                this.storeChangedValues(gv, changedValues);
            }
            transaction.commit();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    @Override
    public void storeRecord(@Nonnull AuditingCategory category, String categoryName, @Nonnull String summary, @Nonnull String eventSource, @Nullable ApplicationUser author, @Nullable String remoteAddress, @Nullable AssociatedItem objectItem, @Nullable Iterable<ChangedValue> changedValues, @Nullable Iterable<AssociatedItem> associatedItems, boolean isAuthorSysAdmin) {
        AuditingEntry entry = AuditingEntry.builder(category, summary, eventSource).categoryName(categoryName).author(author).remoteAddress(remoteAddress).objectItem(objectItem).changedValues(changedValues).associatedItems(associatedItems).isAuthorSysAdmin(isAuthorSysAdmin).build();
        this.storeRecord(entry);
    }

    public static String computeSearchField(String summary, AssociatedItem objectItem, Iterable<AssociatedItem> associatedItems, Iterable<ChangedValue> changedValues, String remoteAddress, ApplicationUser author, String categoryName, String eventSource) {
        SearchTokenizer tokenizer = new SearchTokenizer();
        if (author != null) {
            tokenizer.put(author.getName());
            tokenizer.put(author.getDisplayName());
        }
        tokenizer.put(remoteAddress);
        tokenizer.put(summary);
        tokenizer.put(categoryName);
        if (objectItem != null) {
            tokenizer.put(objectItem.getObjectName());
            tokenizer.put(objectItem.getParentName());
        }
        if (StringUtils.isNotEmpty((CharSequence)eventSource)) {
            tokenizer.put(eventSource);
        }
        if (associatedItems != null) {
            for (AssociatedItem item : associatedItems) {
                tokenizer.put(item.getObjectName());
                tokenizer.put(item.getParentName());
            }
        }
        if (changedValues != null) {
            for (ChangedValue changedValue : changedValues) {
                tokenizer.put(changedValue.getFrom());
                tokenizer.put(changedValue.getTo());
            }
        }
        return tokenizer.getTokenizedString();
    }

    protected void storeChangedValues(@Nonnull GenericValue gv, @Nonnull Iterable<ChangedValue> changedValues) {
        for (ChangedValue changedValue : changedValues) {
            HashMap values = Maps.newHashMap();
            values.put("logId", gv.get("id"));
            values.put("name", changedValue.getName());
            values.put("deltaFrom", changedValue.getFrom());
            values.put("deltaTo", changedValue.getTo());
            this.ofBizDelegator.createValue(CHANGED_VALUES_ENTITY_NAME, (Map)values);
        }
    }

    protected void storeAssociatedItems(@Nonnull GenericValue gv, @Nonnull Iterable<AssociatedItem> associatedItems) {
        for (AssociatedItem item : associatedItems) {
            HashMap values = Maps.newHashMap();
            values.put("logId", gv.getLong("id"));
            values.put("objectId", item.getObjectId());
            values.put("objectName", item.getObjectName());
            values.put("objectParentId", item.getParentId());
            values.put("objectParentName", item.getParentName());
            values.put("objectType", item.getObjectType().toString());
            this.ofBizDelegator.createValue(ITEMS_ENTITY_NAME, (Map)values);
        }
    }

    @Override
    @Nonnull
    public Records getRecords(@Nullable Long maxId, @Nullable Long sinceId, @Nullable Integer maxResults, @Nullable Integer offset, @Nullable AuditingFilter filter, boolean includeSysAdminActions) {
        int limit = maxResults != null && maxResults < 10000 ? maxResults : 10000;
        QueryCallback<List> fetchCallback = dbConnection -> this.getQuery(maxId, sinceId, offset, filter, includeSysAdminActions, limit, dbConnection).fetch();
        QueryCallback<Long> countCallback = dbConnection -> this.getQuery(maxId, sinceId, offset, filter, includeSysAdminActions, limit, dbConnection).fetchCount();
        List records = this.queryDslAccessor.executeQuery(fetchCallback);
        final ImmutableList<AuditRecord> auditRecords = this.getAuditRecords(records);
        final long count = this.queryDslAccessor.executeQuery(countCallback);
        return new Records(){

            public Iterable<AuditRecord> getRecords() {
                return auditRecords;
            }

            public List<AuditRecord> getResults() {
                return auditRecords;
            }

            public long getCount() {
                return count;
            }

            public int getMaxResults() {
                return 10000;
            }
        };
    }

    private SQLQuery<AuditLogDTO> getQuery(@Nullable Long maxId, @Nullable Long sinceId, @Nullable Integer offset, @Nullable AuditingFilter filter, boolean includeSysAdminActions, int limit, DbConnection dbConnection) {
        SQLQuery query = (SQLQuery)dbConnection.newSqlQuery().select((Expression)QAuditLog.AUDIT_LOG).from((Expression)QAuditLog.AUDIT_LOG);
        if (!includeSysAdminActions) {
            query = (SQLQuery)query.where((Predicate)QAuditLog.AUDIT_LOG.authorType.longValue().ne((Object)1L));
        }
        if (offset != null) {
            query = (SQLQuery)query.offset((long)offset.intValue());
        }
        if (maxId != null) {
            query = (SQLQuery)query.where((Predicate)QAuditLog.AUDIT_LOG.id.loe((Number)maxId));
        }
        if (sinceId != null) {
            query = (SQLQuery)query.where((Predicate)QAuditLog.AUDIT_LOG.id.goe((Number)sinceId));
        }
        if (filter != null) {
            query = this.getFilteredQuery(filter, (SQLQuery<AuditLogDTO>)query);
        }
        return (SQLQuery)((SQLQuery)query.orderBy(QAuditLog.AUDIT_LOG.id.desc())).limit((long)limit);
    }

    private SQLQuery<AuditLogDTO> getFilteredQuery(@Nullable AuditingFilter filter, SQLQuery<AuditLogDTO> query) {
        ImmutableSet<String> tokens;
        if (filter.hasProjectIds().booleanValue() || filter.hasUserIds().booleanValue()) {
            query = (SQLQuery)((SQLQuery)query.leftJoin((EntityPath)QAuditItem.AUDIT_ITEM)).on((Predicate)QAuditLog.AUDIT_LOG.id.eq(QAuditItem.AUDIT_ITEM.logId));
            if (filter.hasProjectIds().booleanValue()) {
                List<String> converterdProjectIds = filter.getProjectIds().stream().map(Object::toString).collect(Collectors.toList());
                query = (SQLQuery)query.where((Predicate)this.auditItemOfIds(converterdProjectIds, AssociatedItem.Type.PROJECT).or((Predicate)this.auditLogOfIds(converterdProjectIds, AssociatedItem.Type.PROJECT)));
            }
            if (filter.hasUserIds().booleanValue()) {
                List<String> convertedUserIds = filter.getUserIds().stream().map(Object::toString).collect(Collectors.toList());
                query = (SQLQuery)query.where((Predicate)this.auditItemOfIds(convertedUserIds, AssociatedItem.Type.USER).or((Predicate)this.auditLogOfIds(convertedUserIds, AssociatedItem.Type.USER)).or((Predicate)QAuditLog.AUDIT_LOG.authorKey.in(convertedUserIds)));
            }
        }
        if ((tokens = SearchTokenizer.tokenize(filter.getFilter())) != null) {
            for (String token : tokens) {
                query = (SQLQuery)query.where((Predicate)QAuditLog.AUDIT_LOG.searchField.like("%" + token + "%"));
            }
        }
        Long fromTimestamp = filter.getFromTimestamp();
        Long toTimestamp = filter.getToTimestamp();
        if (fromTimestamp != null) {
            query = (SQLQuery)query.where((Predicate)QAuditLog.AUDIT_LOG.created.goe((Comparable)new Timestamp(fromTimestamp)));
        }
        if (toTimestamp != null) {
            query = (SQLQuery)query.where((Predicate)QAuditLog.AUDIT_LOG.created.loe((Comparable)new Timestamp(toTimestamp)));
        }
        if (filter.isHideExternalDirectories()) {
            query = (SQLQuery)((SQLQuery)query.where((Predicate)QAuditLog.AUDIT_LOG.category.ne((Object)AuditingCategory.USER_MANAGEMENT.toString()).or((Predicate)QAuditLog.AUDIT_LOG.category.eq((Object)AuditingCategory.USER_MANAGEMENT.toString()).and((Predicate)QAuditLog.AUDIT_LOG.objectId.eq((Object)JIRA_INTERNAL_DIRECTORY_ID))))).where((Predicate)QAuditLog.AUDIT_LOG.category.ne((Object)AuditingCategory.GROUP_MANAGEMENT.toString()).or((Predicate)QAuditLog.AUDIT_LOG.category.eq((Object)AuditingCategory.GROUP_MANAGEMENT.toString()).and((Predicate)QAuditLog.AUDIT_LOG.objectId.eq((Object)JIRA_INTERNAL_DIRECTORY_ID))));
        }
        return query;
    }

    private BooleanExpression auditLogOfIds(List<String> convertedUserIds, AssociatedItem.Type elementType) {
        return QAuditLog.AUDIT_LOG.objectType.eq((Object)elementType.toString()).and((Predicate)QAuditLog.AUDIT_LOG.objectId.in(convertedUserIds));
    }

    private BooleanExpression auditItemOfIds(List<String> elementIds, AssociatedItem.Type elementType) {
        return QAuditItem.AUDIT_ITEM.objectType.eq((Object)elementType.toString()).and((Predicate)QAuditItem.AUDIT_ITEM.objectId.in(elementIds));
    }

    private ImmutableList<AuditRecord> getAuditRecords(List<AuditLogDTO> records) {
        if (records == null || records.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList logIds = ImmutableList.copyOf((Iterable)Iterables.transform(records, input -> input.getId()));
        Multimap<Long, GenericValue> logsToItems = this.getItems((List<Long>)logIds);
        Multimap<Long, GenericValue> logsToValues = this.getChangedValues((List<Long>)logIds);
        return ImmutableList.copyOf((Iterable)Iterables.transform(records, input -> {
            Long id = input.getId();
            Iterable items = Iterables.transform((Iterable)logsToItems.get((Object)id), AssociatedItemImpl.from());
            AbstractEntityFactory<ChangedValue> changeValueEntityFactory = this.getChangeValueEntityFactory();
            Iterable changedValues = Iterables.transform((Iterable)logsToValues.get((Object)id), changeValueEntityFactory::build);
            return new AuditRecordImpl(input.toGenericValue(this.ofBizDelegator), items, changedValues);
        }));
    }

    private Multimap<Long, GenericValue> getChangedValues(List<Long> logIds) {
        LinkedHashMultimap logsToValues = LinkedHashMultimap.create((int)logIds.size(), (int)10);
        Select.from(CHANGED_VALUES_ENTITY_NAME).whereCondition((EntityCondition)new EntityExpr("logId", EntityOperator.IN, logIds)).orderBy("logId, id asc").runWith(this.ofBizDelegator).visitWith(arg_0 -> AuditingStoreImpl.lambda$getChangedValues$4((Multimap)logsToValues, arg_0));
        return logsToValues;
    }

    private Multimap<Long, GenericValue> getItems(List<Long> logIds) {
        LinkedHashMultimap logsToItems = LinkedHashMultimap.create((int)logIds.size(), (int)10);
        Select.from(ITEMS_ENTITY_NAME).whereCondition((EntityCondition)new EntityExpr("logId", EntityOperator.IN, logIds)).orderBy("logId, id asc").runWith(this.ofBizDelegator).visitWith(arg_0 -> AuditingStoreImpl.lambda$getItems$5((Multimap)logsToItems, arg_0));
        return logsToItems;
    }

    @Override
    public long countRecords(@Nullable Long maxId, @Nullable Long sinceId, boolean includeSysAdminActions) {
        EntityCondition condition = this.getCondition(maxId, sinceId, null, includeSysAdminActions);
        return (condition != null ? Select.from(ENTITY_NAME).whereCondition(condition).runWith(this.ofBizDelegator) : Select.from(ENTITY_NAME).runWith(this.ofBizDelegator)).count();
    }

    @Nullable
    protected EntityCondition getCondition(@Nullable Long maxId, @Nullable Long sinceId, @Nullable AuditingFilter filter, boolean includeSysAdminActions) {
        ArrayList conditions = Lists.newArrayListWithCapacity((int)6);
        if (!includeSysAdminActions) {
            conditions.add(new EntityExpr("authorType", EntityOperator.NOT_EQUAL, (Object)1L));
        }
        if (maxId != null) {
            conditions.add(new EntityExpr("id", EntityOperator.LESS_THAN_EQUAL_TO, (Object)maxId));
        }
        if (sinceId != null) {
            conditions.add(new EntityExpr("id", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)sinceId));
        }
        if (filter != null) {
            if (StringUtils.isNotBlank((CharSequence)filter.getFilter())) {
                conditions.add(this.getConditionForFilter(filter.getFilter()));
            }
            if (filter.getFromTimestamp() != null) {
                conditions.add(new EntityExpr("created", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)new Timestamp(filter.getFromTimestamp())));
            }
            if (filter.getToTimestamp() != null) {
                conditions.add(new EntityExpr("created", EntityOperator.LESS_THAN_EQUAL_TO, (Object)new Timestamp(filter.getToTimestamp())));
            }
            if (filter.isHideExternalDirectories()) {
                conditions.add(this.getConditionHidingExternalDirectoryEntriesForCategory(AuditingCategory.USER_MANAGEMENT));
                conditions.add(this.getConditionHidingExternalDirectoryEntriesForCategory(AuditingCategory.GROUP_MANAGEMENT));
            }
        }
        if (conditions.isEmpty()) {
            return null;
        }
        return new EntityConditionList((List)conditions, EntityOperator.AND);
    }

    private EntityExpr getConditionHidingExternalDirectoryEntriesForCategory(AuditingCategory category) {
        return new EntityExpr((EntityCondition)new EntityExpr("category", EntityOperator.NOT_EQUAL, (Object)category.getId()), EntityOperator.OR, (EntityCondition)new EntityExpr((EntityCondition)new EntityExpr("category", EntityOperator.EQUALS, (Object)category.getId()), EntityOperator.AND, (EntityCondition)new EntityExpr("objectParentId", EntityOperator.EQUALS, (Object)JIRA_INTERNAL_DIRECTORY_ID)));
    }

    private EntityCondition getConditionForFilter(String filter) {
        Iterable conditions = Iterables.transform(SearchTokenizer.tokenize(filter), token -> new EntityExpr("searchField", EntityOperator.LIKE, (Object)("%" + token + "%")));
        return new EntityExprList((List)ImmutableList.copyOf((Iterable)conditions), EntityOperator.AND);
    }

    @Override
    public long removeRecordsOlderThan(long timestamp) {
        AtomicInteger deleted = new AtomicInteger();
        this.runWhileReturnsResults(Select.from(ENTITY_NAME).whereCondition((EntityCondition)this.createdBefore(timestamp)).orderBy("id asc").limit(10000).runWith(this.ofBizDelegator)).visitWith((Visitor<GenericValue>)((Visitor)element -> {
            Transaction transaction = this.transactionSupport.begin();
            try {
                element.removeRelated("ChildAuditItem");
                element.removeRelated("ChildAuditChangedValue");
                element.remove();
                transaction.commit();
                deleted.incrementAndGet();
            }
            catch (GenericEntityException e) {
                throw new RuntimeException(e);
            }
            finally {
                transaction.finallyRollbackIfNotCommitted();
            }
        }));
        return deleted.intValue();
    }

    @Override
    public long countRecordsOlderThan(long timestamp) {
        return Select.from(ENTITY_NAME).whereCondition((EntityCondition)this.createdBefore(timestamp)).runWith(this.ofBizDelegator).count();
    }

    private VisitorContext<GenericValue> runWhileReturnsResults(final SelectQuery.ExecutionContext<GenericValue> select) {
        return new VisitorContext<GenericValue>(){

            @Override
            public void visitWith(Visitor<GenericValue> visitor) {
                while (this.runSingleQuery(visitor) != 0) {
                }
            }

            private int runSingleQuery(Visitor<GenericValue> visitor) {
                AtomicInteger executionCount = new AtomicInteger();
                select.visitWith(element -> {
                    visitor.visit(element);
                    executionCount.incrementAndGet();
                });
                return executionCount.intValue();
            }
        };
    }

    private EntityExpr createdBefore(long timestamp) {
        return new EntityExpr("created", EntityOperator.LESS_THAN_EQUAL_TO, (Object)new Timestamp(timestamp));
    }

    private AbstractEntityFactory<ChangedValue> getChangeValueEntityFactory() {
        return new AbstractEntityFactory<ChangedValue>(){

            @Override
            public Map<String, Object> fieldMapFrom(ChangedValue value) {
                throw new UnsupportedOperationException("Not implemented");
            }

            @Override
            public String getEntityName() {
                return AuditingStoreImpl.CHANGED_VALUES_ENTITY_NAME;
            }

            @Override
            public ChangedValueImpl build(GenericValue genericValue) {
                return new ChangedValueImpl(genericValue.getString("name"), genericValue.getString("deltaFrom"), genericValue.getString("deltaTo"));
            }
        };
    }

    private static /* synthetic */ void lambda$getItems$5(Multimap logsToItems, GenericValue element) {
        logsToItems.put((Object)element.getLong("logId"), (Object)element);
    }

    private static /* synthetic */ void lambda$getChangedValues$4(Multimap logsToValues, GenericValue element) {
        logsToValues.put((Object)element.getLong("logId"), (Object)element);
    }

    private static interface VisitorContext<E> {
        public void visitWith(Visitor<E> var1);
    }
}

