/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.converters;

import com.atlassian.audit.entity.AuditResource;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class AuditResources {
    static final AuditResource UNSPECIFIED_NULL_RESOURCE = AuditResource.builder((String)"unspecified", (String)AssociatedItem.Type.UNSPECIFIED.name()).build();

    @Nonnull
    public static AuditResource from(@Nonnull FieldScreenScheme scheme) {
        return AuditResource.builder((String)scheme.getName(), (String)AssociatedItem.Type.SCHEME.name()).id(scheme.getId().toString()).build();
    }

    @Nullable
    public static AuditResource from(@Nonnull FieldScreenSchemeItem item) {
        return Optional.ofNullable(item.getFieldScreen()).map(AuditResources::from).orElse(null);
    }

    @Nonnull
    public static AuditResource from(@Nonnull FieldScreen screen) {
        return AuditResource.builder((String)screen.getName(), (String)AssociatedItem.Type.SCREEN.name()).id(screen.getId().toString()).build();
    }

    @Nonnull
    public static AuditResource from(@Nonnull Issue issue) {
        String key = issue.getKey() != null ? issue.getKey() : "";
        return AuditResources.getIssueResourceBuilder(key).id(issue.getId().toString()).build();
    }

    @Nonnull
    public static AuditResource from(@Nonnull Comment comment) {
        return AuditResources.getCommentResourceBuilder(comment).id(AuditResources.getCommentId(comment)).build();
    }

    @Nonnull
    public static AuditResource from(@Nonnull IssueLinkType linkType) {
        return AuditResource.builder((String)linkType.getName(), (String)AssociatedItem.Type.ISSUE_LINK_TYPE.name()).id(linkType.getId().toString()).build();
    }

    public static AuditResource from(@Nonnull ApplicationUser user) {
        return AuditResource.builder((String)user.getName(), (String)AssociatedItem.Type.USER.name()).id(user.getId().toString()).build();
    }

    public static AuditResource unknownUserFrom(@Nonnull String username) {
        return AuditResource.builder((String)username, (String)AssociatedItem.Type.UNKNOWN_USER.name()).build();
    }

    @Nonnull
    public static AuditResource from(@Nonnull Node node) {
        return AuditResource.builder((String)StringUtils.defaultString((String)node.getNodeId(), (String)""), (String)AssociatedItem.Type.CLUSTER_NODE.name()).id(node.getNodeId()).build();
    }

    private static String getCommentId(@Nonnull Comment comment) {
        Long id = comment.getId();
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    private static AuditResource.Builder getCommentResourceBuilder(@Nonnull Comment comment) {
        String key = "";
        Issue issue = comment.getIssue();
        if (issue != null) {
            key = StringUtils.defaultString((String)issue.getKey(), (String)"");
        }
        AuditResource.Builder builder = AuditResources.getIssueResourceBuilder(key);
        return builder;
    }

    private static AuditResource.Builder getIssueResourceBuilder(String key) {
        return AuditResource.builder((String)key, (String)AssociatedItem.Type.ISSUE.name());
    }
}

