/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.handlers.DefaultAssigneeTypeHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;

@AuditExceptionSafe
public class DefaultAssigneeTypeHandlerImpl
implements DefaultAssigneeTypeHandler {
    private static final AuditType DEFAULT_ASSIGNEE_TYPE_UPDATED = AuditEntitiesUtils.newAuditType(CoverageArea.PERMISSIONS, AuditingCategory.PROJECTS, "jira.auditing.project.default.assignee.updated", CoverageLevel.ADVANCED);
    private final AuditService auditService;
    private final I18nHelper i18nHelper;

    public DefaultAssigneeTypeHandlerImpl(AuditService auditService, I18nHelper i18nHelper) {
        this.auditService = auditService;
        this.i18nHelper = i18nHelper;
    }

    @Override
    @ThrowSafe
    public void handleDefaultAssigneeTypeUpdated(Project projectUpdated, Long oldDefaultAssigneeType, Long newDefaultAssigneeType) {
        this.auditService.audit(AuditEvent.builder((AuditType)DEFAULT_ASSIGNEE_TYPE_UPDATED).changedValue(AuditEntitiesUtils.newChangedValue("admin.projects.default.assignee", this.toString(oldDefaultAssigneeType), this.toString(newDefaultAssigneeType))).affectedObject(AuditResource.builder((String)projectUpdated.getName(), (String)AssociatedItem.Type.PROJECT.name()).id(projectUpdated.getId().toString()).build()).build());
    }

    private String toString(Long defaultAssigneeType) {
        if (Long.valueOf(3L).equals(defaultAssigneeType)) {
            return this.i18nHelper.getText("admin.assignee.type.unassigned");
        }
        if (Long.valueOf(2L).equals(defaultAssigneeType)) {
            return this.i18nHelper.getText("admin.assignee.type.project.lead");
        }
        return "";
    }
}

