/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.converters.AuditResources;
import com.atlassian.jira.auditing.handlers.IssueStateAuditHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.issue.Issue;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@AuditExceptionSafe
public final class IssueStateAuditHandlerImpl
implements IssueStateAuditHandler {
    @VisibleForTesting
    static final AuditType ISSUE_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.ISSUE, "jira.auditing.issue.deleted", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType SUBTASK_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.ISSUE, "jira.auditing.subtask.deleted", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_ARCHIVED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.ISSUE, "jira.auditing.issue.archived", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_RESTORED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.ISSUE, "jira.auditing.issue.restored", CoverageLevel.ADVANCED);
    private static final AuditType ISSUE_CREATED = AuditEntitiesUtils.newAuditType(CoverageArea.END_USER_ACTIVITY, AuditingCategory.ISSUE, "jira.auditing.issue.created", CoverageLevel.FULL);
    private final AuditService auditService;

    public IssueStateAuditHandlerImpl(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    @ThrowSafe
    public void onIssueDeleted(@Nonnull Issue issue) {
        Objects.requireNonNull(issue);
        AuditType auditType = issue.isSubTask() ? SUBTASK_DELETED : ISSUE_DELETED;
        AuditEvent.Builder entityBuilder = AuditEvent.builder((AuditType)auditType).affectedObject(AuditResource.builder((String)StringUtils.defaultString((String)issue.getKey()), (String)AssociatedItem.Type.ISSUE.name()).id(issue.getId().toString()).build());
        if (issue.isSubTask()) {
            this.getParentIssueKey(issue).ifPresent(parentKey -> entityBuilder.extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.subtask.parent.key", parentKey)));
        }
        this.auditService.audit(entityBuilder.build());
    }

    private Optional<String> getParentIssueKey(Issue issue) {
        Issue parentObject = issue.getParentObject();
        if (parentObject == null || parentObject.getKey() == null) {
            return Optional.empty();
        }
        return Optional.of(parentObject.getKey());
    }

    @Override
    @ThrowSafe
    public void onIssueArchived(@Nonnull Issue issue, @Nonnull List<String> subTaskIssueKeys) {
        this.auditIssueEvent(ISSUE_ARCHIVED, issue, subTaskIssueKeys);
    }

    @Override
    @ThrowSafe
    public void onIssueRestored(@Nonnull Issue issue, @Nonnull List<String> subTaskIssueKeys) {
        this.auditIssueEvent(ISSUE_RESTORED, issue, subTaskIssueKeys);
    }

    private void auditIssueEvent(AuditType auditType, @Nonnull Issue issue, @Nonnull List<String> subTaskIssueKeys) {
        Objects.requireNonNull(issue);
        Objects.requireNonNull(subTaskIssueKeys);
        List subTasks = subTaskIssueKeys.stream().map(item -> AuditEntitiesUtils.newAuditAttribute("Sub task", item)).collect(Collectors.toList());
        String key = issue.getKey() != null ? issue.getKey() : "";
        AuditEvent auditEvent = AuditEvent.builder((AuditType)auditType).extraAttributes(subTasks).affectedObject(AuditResource.builder((String)key, (String)AssociatedItem.Type.ISSUE.name()).id(issue.getId().toString()).build()).build();
        this.auditService.audit(auditEvent);
    }

    @Override
    @ThrowSafe
    public void onIssueCreated(@Nonnull Issue issue) {
        Objects.requireNonNull(issue);
        AuditEvent auditEvent = AuditEvent.builder((AuditType)ISSUE_CREATED).affectedObject(AuditResources.from(issue)).build();
        this.auditService.audit(auditEvent);
    }
}

