/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.handlers.ServiceEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.service.ServiceDeletedEvent;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.lang3.StringUtils;

@AuditExceptionSafe
public final class ServiceEventHandlerImpl
implements ServiceEventHandler {
    @VisibleForTesting
    static final AuditType JIRASERVICE_DELETED = AuditEntitiesUtils.newAuditType(CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, AuditingCategory.SYSTEM, "jira.auditing.jiraservice.deleted", CoverageLevel.ADVANCED);
    private final I18nHelper i18nHelper;
    private final AuditService auditService;

    public ServiceEventHandlerImpl(I18nHelper i18nHelper, AuditService auditService) {
        this.i18nHelper = i18nHelper;
        this.auditService = auditService;
    }

    private String getDescription(JiraServiceContainer container) {
        return container.getServiceClass() + "; " + this.i18nHelper.getText("jira.auditing.jiraservice.expression") + ": " + container.getCronExpression();
    }

    @Override
    @ThrowSafe
    public void handleServiceDeleted(ServiceDeletedEvent event) {
        JiraServiceContainer container = event.getJiraServiceContainer();
        this.auditService.audit(AuditEvent.builder((AuditType)JIRASERVICE_DELETED).affectedObject(AuditResource.builder((String)StringUtils.defaultString((String)container.getName()), (String)AssociatedItem.Type.JIRA_SERVICE.name()).id(container.getId().toString()).build()).extraAttribute(AuditEntitiesUtils.newAuditAttribute("jira.auditing.jiraservice.class", this.getDescription(container))).build());
    }
}

