/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.event.user.ResetPasswordEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserEmailChangedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.model.user.User;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditEntitiesUtils;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.converters.AuditResources;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.HandlerUtils;
import com.atlassian.jira.auditing.handlers.UserEventHandler;
import com.atlassian.jira.auditing.throwsafe.AuditExceptionSafe;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.throwsafe.ThrowSafe;
import com.atlassian.jira.event.user.CannotChangePasswordEvent;
import com.atlassian.jira.event.user.ForgotPasswordEvent;
import com.atlassian.jira.event.user.ForgotUsernameEvent;
import com.atlassian.jira.event.user.LoginEvent;
import com.atlassian.jira.event.user.LoginFailedEvent;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.event.user.UserRenamedEvent;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationFinishedEvent;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationStartedEvent;
import com.atlassian.jira.event.user.anonymize.UserKeyChangedEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.session.cluster.SessionInvalidationReplicatedEvent;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuditExceptionSafe
public class UserEventHandlerImpl
implements UserEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UserEventHandlerImpl.class);
    @VisibleForTesting
    static final AuditType USER_LOGGED_IN = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.login", "jira.auditing.user.logged.in", CoverageLevel.FULL);
    @VisibleForTesting
    static final AuditType USER_LOGIN_FAILED = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.login", "jira.auditing.user.login.failed", CoverageLevel.FULL);
    private static final AuditType USER_LOGGED_OUT = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.login", "jira.auditing.user.logged.out", CoverageLevel.FULL);
    @VisibleForTesting
    static final AuditType USER_FORGOT_PASSWORD = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.security", "jira.auditing.user.forgot.password", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType USER_FORGOT_USERNAME = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.security", "jira.auditing.user.forgot.username", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType USER_CANNOT_CHANGE_PASSWORD = AuditEntitiesUtils.newAuditType(CoverageArea.SECURITY, "jira.auditing.category.security", "jira.auditing.user.cannot.change.password", CoverageLevel.ADVANCED);
    @VisibleForTesting
    static final AuditType USER_RENAMED = AuditEntitiesUtils.newAuditType(CoverageArea.USER_MANAGEMENT, "jira.auditing.category.usermanagement", "jira.auditing.user.renamed", CoverageLevel.BASE);
    @VisibleForTesting
    static final String UNKNOWN_USERNAME_KEY = "jira.auditing.user.not.known.username";
    @VisibleForTesting
    static final String EMAIL_WORD_KEY = "common.words.email";
    @VisibleForTesting
    static final String AUTHENTICATION_DENIED_KEY = "jira.auditing.user.login.failed.authentication.denied";
    @VisibleForTesting
    static final String AUTHENTICATION_FAILED_KEY = "jira.auditing.user.login.failed.authentication.failed";
    @VisibleForTesting
    static final String AUTHORISATION_FAILED_KEY = "jira.auditing.user.login.failed.authorisation.failed";
    @VisibleForTesting
    static final String REASON_UNKNOWN_KEY = "jira.auditing.user.login.failed.reason.unknown";
    @VisibleForTesting
    static final String LOGIN_FAILED_REASON_KEY = "jira.auditing.user.login.failed.reason";
    @VisibleForTesting
    static final String LOGIN_FAILED_COUNT_KEY = "jira.auditing.user.login.failed.count";
    @VisibleForTesting
    static final String ACCESSED_URL_KEY = "jira.auditing.user.login.failed.accessed.url";
    static final String UNKNOWN_LOGIN_COUNT_KEY = "jira.auditing.user.login.failed.unknown.login.count";
    private final UserKeyService userKeyService;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final AuditService auditService;

    public UserEventHandlerImpl(UserKeyService userKeyService, I18nHelper.BeanFactory i18nBeanFactory, AuditService auditService) {
        this.userKeyService = userKeyService;
        this.i18nBeanFactory = i18nBeanFactory;
        this.auditService = auditService;
    }

    @Override
    public Option<RecordRequest> onUserUpdatedEvent(UserUpdatedEvent event) {
        if (event instanceof AutoUserUpdatedEvent) {
            return this.onAutoUserUpdatedEvent((AutoUserUpdatedEvent)event);
        }
        if (event instanceof ResetPasswordEvent) {
            return Option.option((Object)this.onResetPasswordEvent((ResetPasswordEvent)event));
        }
        if (event instanceof com.atlassian.crowd.event.user.UserRenamedEvent) {
            return Option.none();
        }
        if (event instanceof UserAttributeStoredEvent || event instanceof UserAttributeDeletedEvent) {
            return Option.none();
        }
        if (event instanceof UserEditedEvent) {
            return this.onUserEditedEvent((UserEditedEvent)event);
        }
        if (event instanceof UserEmailChangedEvent) {
            return Option.none();
        }
        throw new RuntimeException("Unsupported event: " + event.getClass().getName());
    }

    private Option<RecordRequest> onAutoUserUpdatedEvent(AutoUserUpdatedEvent event) {
        return this.userUpdated(event.getOriginalUser(), event.getUser());
    }

    private Option<RecordRequest> onUserEditedEvent(UserEditedEvent event) {
        return this.userUpdated(event.getOriginalUser(), event.getUser());
    }

    private Option<RecordRequest> userUpdated(User originalUser, User user) {
        return HandlerUtils.requestIfThereAreAnyValues(this.buildChangedValues(originalUser, user), (Function<List<ChangedValue>, RecordRequest>)((Function)changedValues -> new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.updated").withActionI18nKey("jira.auditing.user.updated").withChangedValues((Iterable)changedValues).forObject((AssociatedItem)new AffectedUser(user))));
    }

    private RecordRequest onResetPasswordEvent(ResetPasswordEvent event) {
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.password.reset").withActionI18nKey("jira.auditing.user.password.reset").forObject((AssociatedItem)new AffectedUser(event.getUser()));
    }

    @Override
    @ThrowSafe
    public void onUserRenamedEvent(UserRenamedEvent event) {
        ApplicationUser applicationUser = ComponentAccessor.getUserManager().getUserByName(event.getUsername());
        AuditResource userResource = applicationUser == null ? AuditResources.unknownUserFrom(event.getUsername()) : AuditResources.from(applicationUser);
        this.auditService.audit(AuditEvent.builder((AuditType)USER_RENAMED).affectedObject(userResource).changedValue(AuditEntitiesUtils.newChangedValue("common.words.username", event.getOldUserName(), event.getUsername())).build());
    }

    private List<ChangedValue> buildChangedValues(User originalUser, User currentUser) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.username", originalUser == null ? null : originalUser.getName(), currentUser.getName()).addIfDifferent("common.words.fullname", originalUser == null ? null : originalUser.getDisplayName(), currentUser.getDisplayName()).addIfDifferent(EMAIL_WORD_KEY, originalUser == null ? null : originalUser.getEmailAddress(), currentUser.getEmailAddress()).addIfDifferent("admin.common.phrases.active.inactive", originalUser == null ? null : UserEventHandlerImpl.stringBooleanToActiveInactive(originalUser.isActive()), UserEventHandlerImpl.stringBooleanToActiveInactive(currentUser.isActive()));
        return changedValues.build();
    }

    public static String stringBooleanToActiveInactive(Boolean tBoolean) {
        if (tBoolean == null) {
            return "";
        }
        return tBoolean.equals(Boolean.TRUE) ? "Active" : "Inactive";
    }

    @Override
    public RecordRequest onUserCreatedEvent(UserCreatedEvent event) {
        User user = event.getUser();
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.created").withActionI18nKey("jira.auditing.user.created").withChangedValues(this.buildChangedValues(user)).forObject((AssociatedItem)new AffectedUser(user));
    }

    @Override
    public Option<RecordRequest> onUserDeletedEvent(UserDeletedEvent event) {
        return Option.none();
    }

    @Override
    public RecordRequest onUserCredentialUpdatedEvent(UserCredentialUpdatedEvent event) {
        String userKey = ComponentAccessor.getUserKeyService().getKeyForUsername(event.getUsername());
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.password.changed").withActionI18nKey("jira.auditing.user.password.changed").forObject((AssociatedItem)new AffectedUser(event.getUsername(), userKey, event.getDirectory()));
    }

    private List<ChangedValue> buildChangedValues(User currentUser) {
        return this.buildChangedValues(null, currentUser);
    }

    @Override
    public RecordRequest onUserAnonymizationStartedEvent(UserAnonymizationStartedEvent event) {
        RecordRequest recordRequest = new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.anonymization.started").withActionI18nKey("jira.auditing.user.anonymization.started").withDescription(this.getI18n().getText("jira.auditing.user.anonymization.started.description", event.getUserName(), event.getUserKey())).forObject((AssociatedItem)new AffectedUser(event.getUserName(), event.getUserKey(), null));
        return recordRequest;
    }

    @Override
    public RecordRequest onUserAnonymizationFinishedEvent(UserAnonymizationFinishedEvent event) {
        String rerunPart = "";
        if (event.isReRun()) {
            rerunPart = " " + this.getI18n().getText("jira.auditing.user.anonymized.rerun.description", Optional.ofNullable(event.getReRunUserKey()).orElse("-"), Optional.ofNullable(event.getReRunUserName()).orElse("-"));
        }
        String description = this.getI18n().getText("jira.auditing.user.anonymized.description", event.getUserName(), event.getOldUserName(), event.getUserKey(), event.getOldUserKey());
        RecordRequest recordRequest = new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.anonymized").withActionI18nKey("jira.auditing.user.anonymized").withDescription(description + rerunPart).forObject((AssociatedItem)new AffectedUser(event.getUserName(), event.getUserKey(), null));
        if (!Objects.equals(event.getUserName(), event.getOldUserName())) {
            recordRequest.withAssociatedItems(new AssociatedItem[]{new AffectedUser(event.getOldUserName(), event.getOldUserKey(), null)});
        }
        return recordRequest;
    }

    @Override
    public RecordRequest onUserKeyChangedEvent(UserKeyChangedEvent event) {
        String username = this.userKeyService.getUsernameForKey(event.getNewUserKey());
        RecordRequest recordRequest = new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.key.changed").withActionI18nKey("jira.auditing.user.key.changed").withChangedValues(new ChangedValuesBuilder().add("common.words.key", event.getOldUserKey(), event.getNewUserKey()).build());
        if (username != null) {
            recordRequest.forObject((AssociatedItem)new AffectedUser(username, event.getNewUserKey(), null));
            if (!Objects.equals(event.getOldUserKey(), event.getNewUserKey())) {
                recordRequest.withAssociatedItems(new AssociatedItem[]{new AffectedUser(username, event.getOldUserKey(), null)});
            }
        }
        return recordRequest;
    }

    @Override
    @ThrowSafe
    public void onUserLoggedIn(LoginEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)USER_LOGGED_IN).affectedObject(AuditResources.from(event.getUser())).build());
    }

    @Override
    @ThrowSafe
    public void onUserLoginFailed(LoginFailedEvent event) {
        ArrayList attributes = Lists.newArrayList((Object[])new AuditAttribute[]{this.getFailedLoginCountAttribute(event), this.getFailedLoginReasonAttribute(event)});
        event.getUrl().ifPresent(url -> {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                attributes.add(AuditEntitiesUtils.newAuditAttribute(ACCESSED_URL_KEY, url));
            }
        });
        this.auditService.audit(AuditEvent.builder((AuditType)USER_LOGIN_FAILED).affectedObject(AuditResources.from(event.getUser())).extraAttributes((Collection)attributes).build());
    }

    @Override
    @ThrowSafe
    public void onUserLoggedOut(@Nonnull ApplicationUser user) {
        this.auditService.audit(AuditEvent.builder((AuditType)USER_LOGGED_OUT).affectedObject(AuditResources.from(user)).build());
    }

    @Override
    @ThrowSafe
    public void onUnknownUserLoggedOut(@Nonnull String userName) {
        this.auditService.audit(AuditEvent.builder((AuditType)USER_LOGGED_OUT).affectedObject(AuditResource.builder((String)userName, (String)AssociatedItem.Type.UNKNOWN_USER.name()).build()).build());
    }

    @Override
    @ThrowSafe
    public void onUnknownUserLoginFailed(@Nonnull String userName) {
        this.auditService.audit(AuditEvent.builder((AuditType)USER_LOGIN_FAILED).extraAttribute(AuditEntitiesUtils.newAuditAttribute(LOGIN_FAILED_REASON_KEY, this.getI18n().getText("jira.auditing.user.login.failed.unknown.failed"))).affectedObject(AuditResource.builder((String)userName, (String)AssociatedItem.Type.UNKNOWN_USER.name()).build()).build());
    }

    @Override
    @ThrowSafe
    public void onForgotPasswordEvent(ForgotPasswordEvent event) {
        AuditResource resource = this.getAffectedUserResource((UserEvent)event, () -> this.getUsername((UserEvent)event));
        this.auditService.audit(AuditEvent.builder((AuditType)USER_FORGOT_PASSWORD).affectedObject(resource).build());
    }

    @Override
    @ThrowSafe
    public void onForgotUsernameEvent(ForgotUsernameEvent event) {
        AuditResource resource = this.getAffectedUserResource((UserEvent)event, this::getUnknownUsername);
        String emailAddress = UserEventHandlerImpl.getStringParam((UserEvent)event, "email").orElse("");
        AuditEvent.Builder auditBuilder = AuditEvent.builder((AuditType)USER_FORGOT_USERNAME).affectedObject(resource);
        if (event.getUser() == null) {
            auditBuilder.extraAttribute(AuditEntitiesUtils.newAuditAttribute(EMAIL_WORD_KEY, emailAddress));
        }
        this.auditService.audit(auditBuilder.build());
    }

    @Override
    @ThrowSafe
    public RecordRequest onSessionInvalidationReplicatedEvent(SessionInvalidationReplicatedEvent sessionInvalidationReplicatedEvent) {
        String username = sessionInvalidationReplicatedEvent.getUsername();
        return new RecordRequest(AuditingCategory.SECURITY, "jira.auditing.user.sessions.cleared").withActionI18nKey("jira.auditing.user.sessions.cleared").forObject(AssociatedItem.Type.USER, username);
    }

    @Override
    @ThrowSafe
    public void onCannotChangePasswordEvent(CannotChangePasswordEvent event) {
        this.auditService.audit(AuditEvent.builder((AuditType)USER_CANNOT_CHANGE_PASSWORD).affectedObject(AuditResources.from(event.getUser())).build());
    }

    @Nonnull
    private AuditResource getAffectedUserResource(@Nonnull UserEvent event, Supplier<String> unknownUsername) {
        if (event.getUser() == null) {
            return AuditResources.unknownUserFrom(unknownUsername.get());
        }
        return AuditResources.from(event.getUser());
    }

    @Nonnull
    private AuditAttribute getFailedLoginReasonAttribute(@Nonnull LoginFailedEvent event) {
        String failedLoginReasonKey;
        switch (event.getLoginReason()) {
            case AUTHENTICATION_DENIED: {
                failedLoginReasonKey = AUTHENTICATION_DENIED_KEY;
                break;
            }
            case AUTHENTICATED_FAILED: {
                failedLoginReasonKey = AUTHENTICATION_FAILED_KEY;
                break;
            }
            case AUTHORISATION_FAILED: {
                failedLoginReasonKey = AUTHORISATION_FAILED_KEY;
                break;
            }
            default: {
                failedLoginReasonKey = REASON_UNKNOWN_KEY;
            }
        }
        return AuditEntitiesUtils.newAuditAttribute(LOGIN_FAILED_REASON_KEY, this.getI18n().getText(failedLoginReasonKey));
    }

    @Nonnull
    private AuditAttribute getFailedLoginCountAttribute(@Nonnull LoginFailedEvent event) {
        String failedLoginCount = Optional.ofNullable(event.getLoginInfo().getCurrentFailedLoginCount()).map(Objects::toString).orElse(this.getI18n().getText(UNKNOWN_LOGIN_COUNT_KEY));
        return AuditEntitiesUtils.newAuditAttribute(LOGIN_FAILED_COUNT_KEY, failedLoginCount);
    }

    @Nonnull
    private String getUsername(UserEvent event) {
        return UserEventHandlerImpl.getStringParam(event, "username").orElseGet(this::getUnknownUsername);
    }

    @Nonnull
    private String getUnknownUsername() {
        return this.getI18n().getText(UNKNOWN_USERNAME_KEY);
    }

    @Nonnull
    private static Optional<String> getStringParam(@Nonnull UserEvent event, String key) {
        Object value = event.getParams().get(key);
        if (!(value instanceof String)) {
            LOG.debug("Missing or unexpected value for the '{}' parameter value.", (Object)key);
            return Optional.empty();
        }
        return Optional.of((String)value);
    }

    private I18nHelper getI18n() {
        return this.i18nBeanFactory.getInstance(Locale.ENGLISH);
    }
}

