/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.lookup;

import com.atlassian.audit.api.util.pagination.Page;
import com.atlassian.audit.api.util.pagination.PageRequest;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class PagedLookupSupport<E, R> {
    private final Function<String, List<E>> resourcesSupplier;
    private final Function<E, String> nameMapper;
    private final Function<E, R> toResourceMapper;

    PagedLookupSupport(Function<String, List<E>> resourcesSupplier, Function<E, String> nameMapper, Function<E, R> toResourceMapper) {
        this.resourcesSupplier = resourcesSupplier;
        this.nameMapper = nameMapper;
        this.toResourceMapper = toResourceMapper;
    }

    public Page<R, String> lookupPage(@Nullable String searchTerm, PageRequest<String> pageRequest) {
        List<E> searchResults = this.resourcesSupplier.apply(searchTerm);
        int offset = this.findOffset(searchResults, pageRequest.getCursor().orElse(null));
        int limit = pageRequest.getLimit();
        boolean lastPage = searchResults.size() <= offset + limit;
        List pageContent = searchResults.stream().skip(offset).skip(pageRequest.getOffset()).limit(limit).map(this.toResourceMapper).collect(Collectors.toList());
        Page.Builder builder = new Page.Builder(pageContent, lastPage);
        if (!lastPage) {
            this.addNextPageRequest(builder, this.nameMapper.apply(searchResults.get(pageContent.size() - 1)), limit);
        }
        return builder.build();
    }

    private void addNextPageRequest(Page.Builder<R, String> builder, String cursor, int limit) {
        builder.nextPageRequest(new PageRequest.Builder().cursor((Object)cursor).limit(limit).build());
    }

    private int findOffset(List<E> searchResults, @Nullable String cursor) {
        if (cursor == null || "".equals(cursor)) {
            return 0;
        }
        Iterator<E> iterator = searchResults.iterator();
        int i = 0;
        while (iterator.hasNext() && !this.nameMapper.apply(iterator.next()).equals(cursor)) {
            ++i;
        }
        return i + 1;
    }
}

