/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.spis.migration.mapping;

import com.atlassian.audit.entity.AuditResource;
import com.atlassian.jira.auditing.spis.migration.mapping.AuditResourceConverter;
import com.atlassian.jira.model.querydsl.AuditItemDTO;
import com.atlassian.jira.model.querydsl.AuditLogDTO;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class AuditResourcesConverter
implements BiFunction<AuditLogDTO, Collection<AuditItemDTO>, List<AuditResource>> {
    private final AuditResourceConverter auditResourceConverter;

    public AuditResourcesConverter(@Nonnull AuditResourceConverter auditResourceConverter) {
        this.auditResourceConverter = Objects.requireNonNull(auditResourceConverter);
    }

    @Override
    @Nonnull
    public List<AuditResource> apply(@Nonnull AuditLogDTO auditLog, @Nonnull Collection<AuditItemDTO> auditItems) {
        Stream<AuditResource> auditResourcesFromAuditLog = Stream.concat(this.auditResourceConverter.convert(auditLog.getObjectId(), auditLog.getObjectName(), auditLog.getObjectType()), this.auditResourceConverter.convert(auditLog.getObjectParentId(), auditLog.getObjectParentName(), null));
        return Stream.concat(auditResourcesFromAuditLog, auditItems.stream().flatMap(this.auditResourceConverter::apply)).collect(Collectors.toList());
    }
}

