/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.dc.filestore.api.FileStore;
import com.atlassian.jira.avatar.AvatarFileStoreProvider;
import com.atlassian.jira.config.filestore.FileStoreAssociationTarget;
import com.atlassian.jira.config.filestore.loader.FileStoresConfigurationLoader;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.filestore.S3FileStoreProvider;
import javax.annotation.Nonnull;

public class S3AvatarFileStoreProvider
extends S3FileStoreProvider
implements AvatarFileStoreProvider {
    @VisibleForTesting
    static final String S3_AVATAR_PATH_PREFIX = "avatars";

    public S3AvatarFileStoreProvider(JiraProperties jiraProperties, FileStoresConfigurationLoader fileStoresConfigurationLoader) {
        super(FileStoreAssociationTarget.AVATARS, jiraProperties, fileStoresConfigurationLoader);
    }

    @Override
    @Nonnull
    public FileStore.Path getBasePath() {
        return this.getS3FileStore().root().path(new String[]{S3_AVATAR_PATH_PREFIX});
    }

    @Override
    public boolean isStoreInJiraHome() {
        return false;
    }

    @Override
    public FileStoreAssociationTarget getAssociationTarget() {
        return FileStoreAssociationTarget.AVATARS;
    }
}

