/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.fields.screen;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.action.screen.AddFieldToScreenUtilImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenId;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenLayoutItemId;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenOperationContext;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenService;
import com.atlassian.jira.bc.issue.fields.screen.FieldScreenTabId;
import com.atlassian.jira.bc.issue.fields.screen.MoveFieldInfo;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldAddedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldMovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldRemovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenFieldShownWhenEmptyEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabAddedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabMovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabRemovedEvent;
import com.atlassian.jira.event.issue.field.screen.FieldScreenTabRenamedEvent;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.FieldWithShowWhenEmpty;
import com.atlassian.jira.issue.fields.ImmutableFieldWithShowWhenEmpty;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultFieldScreenService
implements FieldScreenService {
    private static final String FIELD_DOESNT_EXIST = "admin.screens.error.field.doesnt.exist";
    private final I18nHelper.BeanFactory i18nFactory;
    private final FieldScreenManager fieldScreenManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectFieldScreenHelper projectFieldScreenHelper;
    private final FieldManager fieldManager;
    private final EventPublisher eventPublisher;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final WorkflowManager workflowManager;

    public DefaultFieldScreenService(I18nHelper.BeanFactory i18nFactory, FieldScreenManager fieldScreenManager, GlobalPermissionManager globalPermissionManager, ProjectFieldScreenHelper projectFieldScreenHelper, FieldManager fieldManager, EventPublisher eventPublisher, FieldScreenSchemeManager fieldScreenSchemeManager, WorkflowManager workflowManager) {
        this.i18nFactory = i18nFactory;
        this.fieldScreenManager = fieldScreenManager;
        this.globalPermissionManager = globalPermissionManager;
        this.projectFieldScreenHelper = projectFieldScreenHelper;
        this.fieldManager = fieldManager;
        this.eventPublisher = eventPublisher;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.workflowManager = workflowManager;
    }

    public ServiceOutcome<FieldScreen> copy(FieldScreen screenToCopy, String copyName, String copyDescription, ApplicationUser loggedInUser) {
        FieldScreenOperationContext context = FieldScreenOperationContext.ofUser((ApplicationUser)loggedInUser);
        I18nHelper i18n = this.i18nFactory.getInstance(loggedInUser);
        if (!TextUtils.stringSet((String)copyName)) {
            return ServiceOutcomeImpl.error(i18n.getText("admin.common.errors.validname"));
        }
        if (!this.administerPermissionCheck(context)) {
            return this.noPermission(context);
        }
        for (FieldScreen fieldScreen : this.fieldScreenManager.getFieldScreens()) {
            if (!copyName.equals(fieldScreen.getName())) continue;
            return ServiceOutcomeImpl.error(i18n.getText("admin.errors.screens.duplicate.screen.name"));
        }
        FieldScreenImpl copy = new FieldScreenImpl(this.fieldScreenManager, null);
        copy.setName(copyName);
        copy.setDescription(copyDescription);
        copy.store();
        for (FieldScreenTab fieldScreenTab : screenToCopy.getTabs()) {
            FieldScreenTab copyFieldScreenTab = copy.addTab(fieldScreenTab.getName());
            for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenTab.getFieldScreenLayoutItems()) {
                copyFieldScreenTab.addFieldScreenLayoutItem(fieldScreenLayoutItem.getFieldId());
            }
        }
        return ServiceOutcomeImpl.ok(copy);
    }

    public ServiceOutcome<List<FieldScreenTab>> getAllTabs(FieldScreenId screenId, FieldScreenOperationContext context) {
        return this.getScreenById(screenId).flatMap(screen -> this.projectAdminOrAdministratorPermissionCheck((FieldScreen)screen, context) ? Optional.of(screen.getTabs()) : Optional.empty()).map(ServiceOutcomeImpl::ok).orElseGet(() -> this.noPermission(context));
    }

    public ServiceOutcome<FieldScreenTab> addTab(FieldScreenId screenId, String tabName, FieldScreenOperationContext context) {
        Optional<FieldScreen> screen = this.getScreenById(screenId);
        if (!screen.isPresent() || !this.editScreenPermissionCheck(screen.get(), context)) {
            return this.noPermission(context);
        }
        if (StringUtils.isEmpty((CharSequence)tabName)) {
            return ServiceOutcomeImpl.from(DefaultFieldScreenService.singleValidationError("name", this.getI18n(context).getText("admin.screens.error.tab.empty")));
        }
        if (this.getTabByName(screen.get(), tabName) != null) {
            return ServiceOutcomeImpl.from(DefaultFieldScreenService.singleValidationError("name", this.getI18n(context).getText("admin.screens.errors.tab.exists", tabName)));
        }
        FieldScreenTab addedTab = screen.get().addTab(tabName);
        this.eventPublisher.publish((Object)new FieldScreenTabAddedEvent(addedTab));
        return ServiceOutcomeImpl.ok(addedTab);
    }

    public ServiceOutcome<FieldScreenTab> renameTab(FieldScreenTabId tabId, String newName, FieldScreenOperationContext context) {
        Optional<FieldScreenTab> tab = this.getTabById(tabId);
        if (!tab.isPresent() || !this.editScreenPermissionCheck(tab.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        if (StringUtils.isEmpty((CharSequence)newName)) {
            return ServiceOutcomeImpl.from(DefaultFieldScreenService.singleValidationError("name", this.getI18n(context).getText("admin.screens.error.tab.empty")));
        }
        FieldScreenTab tabObject = tab.get();
        if (this.getTabByName(tabObject.getFieldScreen(), newName) != null) {
            return ServiceOutcomeImpl.from(DefaultFieldScreenService.singleValidationError("name", this.getI18n(context).getText("admin.screens.errors.tab.exists", newName)));
        }
        String oldName = tabObject.getName();
        tabObject.rename(newName);
        this.eventPublisher.publish((Object)new FieldScreenTabRenamedEvent(tabObject, oldName, newName));
        return ServiceOutcomeImpl.ok(tabObject);
    }

    public ServiceResult removeTab(FieldScreenTabId tabId, FieldScreenOperationContext context) {
        Optional<FieldScreenTab> tab = this.getTabById(tabId);
        if (!tab.isPresent() || !this.editScreenPermissionCheck(tab.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        FieldScreenTab tabObject = tab.get();
        if (tabObject.getFieldScreen().getTabs().size() < 2) {
            return ServiceOutcomeImpl.error(this.getI18n(context).getText("admin.screens.error.cannot.remove.last.lab"), ErrorCollection.Reason.PRECONDITION_FAILED);
        }
        tabObject.getFieldScreen().removeTab(tabObject.getPosition());
        this.eventPublisher.publish((Object)new FieldScreenTabRemovedEvent(tabObject));
        return DefaultFieldScreenService.okServiceResult();
    }

    public ServiceOutcome<FieldScreenTab> moveTab(FieldScreenTabId tabId, Integer position, FieldScreenOperationContext context) {
        Optional<FieldScreenTab> tab = this.getTabById(tabId);
        if (!tab.isPresent() || !this.editScreenPermissionCheck(tab.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        FieldScreen screen = tab.get().getFieldScreen();
        int size = screen.getTabs().size();
        if (position < 0 || position > size) {
            return ServiceOutcomeImpl.error(this.getI18n(context).getText("admin.screens.error.tab.incorrect.pos", "" + (size - 1)), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        int oldPosition = tab.get().getPosition();
        screen.moveFieldScreenTabToPosition(tab.get().getPosition(), position.intValue());
        screen.store();
        this.eventPublisher.publish((Object)new FieldScreenTabMovedEvent(tab.get(), oldPosition, position));
        return ServiceOutcomeImpl.ok(tab.get());
    }

    public ServiceOutcome<List<Field>> getFieldsOnTab(FieldScreenTabId tabId, FieldScreenOperationContext context) {
        Optional<FieldScreenTab> tab = this.getTabById(tabId);
        if (!tab.isPresent() || !this.projectAdminOrAdministratorPermissionCheck(tab.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        List fieldScreenLayoutItems = tab.get().getFieldScreenLayoutItems();
        ArrayList<Field> fields = new ArrayList<Field>(fieldScreenLayoutItems.size());
        for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenLayoutItems) {
            Field field = this.fieldManager.getField(fieldScreenLayoutItem.getFieldId());
            if (field == null) continue;
            fields.add(field);
        }
        return ServiceOutcomeImpl.ok(fields);
    }

    public ServiceOutcome<List<OrderableField>> getAvailableFieldsForScreen(FieldScreenId screenId, FieldScreenOperationContext context) {
        Optional<FieldScreen> screen = this.getScreenById(screenId);
        if (!screen.isPresent() || !this.editScreenPermissionCheck(screen.get(), context)) {
            return this.noPermission(context);
        }
        LinkedList addableFields = new LinkedList(this.fieldManager.getOrderableFields());
        List tabs = screen.get().getTabs();
        for (FieldScreenTab fieldScreenTab : tabs) {
            for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenTab.getFieldScreenLayoutItems()) {
                addableFields.remove(fieldScreenLayoutItem.getOrderableField());
            }
        }
        Iterator iterator = addableFields.iterator();
        while (iterator.hasNext()) {
            OrderableField orderableField = (OrderableField)iterator.next();
            if (!this.fieldManager.isUnscreenableField((Field)orderableField)) continue;
            iterator.remove();
        }
        Collections.sort(addableFields);
        return ServiceOutcomeImpl.ok(addableFields);
    }

    public ServiceResult removeField(FieldScreenLayoutItemId item, FieldScreenOperationContext context) {
        Optional<FieldScreenTab> tab = this.getTabById(item.getTabId());
        if (!tab.isPresent() || !this.editScreenPermissionCheck(tab.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        FieldScreenLayoutItem fieldScreenLayoutItem = tab.get().getFieldScreenLayoutItem(item.getFieldId());
        if (fieldScreenLayoutItem == null) {
            return ServiceOutcomeImpl.error(this.getI18n(context).getText(FIELD_DOESNT_EXIST, item.getFieldId()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        tab.get().getFieldScreen().removeFieldScreenLayoutItem(item.getFieldId());
        this.eventPublisher.publish((Object)new FieldScreenFieldRemovedEvent(tab.get(), (Field)fieldScreenLayoutItem.getOrderableField()));
        return DefaultFieldScreenService.okServiceResult();
    }

    public ServiceResult moveField(FieldScreenLayoutItemId fieldToMoveId, MoveFieldInfo moveInfo, FieldScreenOperationContext context) {
        boolean hasFieldOrPositionDefined = moveInfo.getAfterField().isPresent() || moveInfo.getDesiredPosition().isPresent();
        Preconditions.checkArgument((boolean)hasFieldOrPositionDefined, (Object)"Either field or position have to be defined");
        Optional<FieldScreenTab> tabOptional = this.getTabById(fieldToMoveId.getTabId());
        if (!tabOptional.isPresent() || !this.editScreenPermissionCheck(tabOptional.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        FieldScreenTab tab = tabOptional.get();
        FieldScreenLayoutItem fieldToMove = tab.getFieldScreenLayoutItem(fieldToMoveId.getFieldId());
        if (fieldToMove == null) {
            return ServiceOutcomeImpl.error(this.getI18n(context).getText(FIELD_DOESNT_EXIST, fieldToMoveId.getFieldId()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        int oldFieldPosition = fieldToMove.getPosition();
        if (moveInfo.getAfterField().isPresent()) {
            FieldScreenLayoutItem afterFieldItem = tab.getFieldScreenLayoutItem((String)moveInfo.getAfterField().get());
            if (afterFieldItem == null) {
                return ServiceOutcomeImpl.error(this.getI18n(context).getText("admin.screens.error.field.move.invalid", fieldToMoveId.getFieldId(), (String)moveInfo.getAfterField().get()), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            int target = afterFieldItem.getPosition();
            if (target < oldFieldPosition) {
                ++target;
            }
            if (target >= tab.getFieldScreenLayoutItems().size()) {
                tab.moveFieldScreenLayoutItemLast(oldFieldPosition);
            } else if (target < 0) {
                tab.moveFieldScreenLayoutItemFirst(oldFieldPosition);
            } else {
                HashMap<Integer, FieldScreenLayoutItem> layoutItemMap = new HashMap<Integer, FieldScreenLayoutItem>();
                layoutItemMap.put(target, fieldToMove);
                tab.moveFieldScreenLayoutItemToPosition(layoutItemMap);
            }
        } else {
            MoveFieldInfo.MoveFieldPosition moveFieldPosition = (MoveFieldInfo.MoveFieldPosition)moveInfo.getDesiredPosition().get();
            if (moveFieldPosition == MoveFieldInfo.MoveFieldPosition.Last) {
                tab.moveFieldScreenLayoutItemLast(oldFieldPosition);
            } else if (moveFieldPosition == MoveFieldInfo.MoveFieldPosition.First) {
                tab.moveFieldScreenLayoutItemFirst(oldFieldPosition);
            }
        }
        this.eventPublisher.publish((Object)new FieldScreenFieldMovedEvent(tab, fieldToMove.getOrderableField(), oldFieldPosition, fieldToMove.getPosition()));
        return DefaultFieldScreenService.okServiceResult();
    }

    public ServiceOutcome<Field> addFieldToScreen(FieldScreenTabId tabId, String fieldId, FieldScreenOperationContext context) {
        Optional<FieldScreenTab> tab = this.getTabById(tabId);
        if (!tab.isPresent()) {
            return this.noPermission(context);
        }
        if (!this.editScreenPermissionCheck(tab.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        AddFieldToScreenUtilImpl addFieldToScreenUtil = this.getAddFieldToScreenUtil();
        addFieldToScreenUtil.setFieldScreenId(tab.get().getFieldScreen().getId());
        addFieldToScreenUtil.setTabPosition(tab.get().getPosition());
        addFieldToScreenUtil.setFieldId(new String[]{fieldId});
        addFieldToScreenUtil.setFieldPosition("" + (tab.get().getFieldScreenLayoutItems().size() + 1));
        ErrorCollection validateResult = addFieldToScreenUtil.validate(context.getUser());
        if (validateResult.hasAnyErrors()) {
            return ServiceOutcomeImpl.from(validateResult);
        }
        addFieldToScreenUtil.execute();
        Field addedField = this.fieldManager.getField(fieldId);
        this.eventPublisher.publish((Object)new FieldScreenFieldAddedEvent(tab.get(), addedField));
        return ServiceOutcomeImpl.ok(addedField);
    }

    public ServiceOutcome<Boolean> getIsFieldScreenDeletable(FieldScreenId id, FieldScreenOperationContext context) {
        boolean hasScreenSchemes;
        Optional<FieldScreen> screen = this.getScreenById(id);
        if (!screen.isPresent()) {
            return this.noPermission(context);
        }
        boolean bl = hasScreenSchemes = !this.fieldScreenSchemeManager.getFieldScreenSchemes(screen.get()).isEmpty();
        if (hasScreenSchemes) {
            return ServiceOutcomeImpl.ok(false);
        }
        for (JiraWorkflow workflow : this.workflowManager.getWorkflowsIncludingDrafts()) {
            Collection actions = workflow.getActionsForScreen(screen.get());
            if (actions.isEmpty()) continue;
            return ServiceOutcomeImpl.ok(false);
        }
        return ServiceOutcomeImpl.ok(true);
    }

    public ServiceResult updateShowWhenEmpty(FieldScreenLayoutItemId itemId, FieldScreenOperationContext context, boolean showWhenEmpty) {
        Optional<FieldScreenTab> tabOptional = this.getTabById(itemId.getTabId());
        if (!tabOptional.isPresent() || !this.editScreenPermissionCheck(tabOptional.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        FieldScreenTab tab = tabOptional.get();
        FieldScreenLayoutItem fieldToUpdate = tab.getFieldScreenLayoutItem(itemId.getFieldId());
        if (fieldToUpdate == null) {
            return ServiceOutcomeImpl.error(this.getI18n(context).getText(FIELD_DOESNT_EXIST, itemId.getFieldId()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (!fieldToUpdate.getFieldId().startsWith("customfield")) {
            return ServiceOutcomeImpl.error(this.getI18n(context).getText("admin.screens.error.field.show.when.empty.system.field"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        fieldToUpdate.setShowWhenEmpty(showWhenEmpty);
        fieldToUpdate.store();
        if (showWhenEmpty) {
            this.eventPublisher.publish((Object)new FieldScreenFieldShownWhenEmptyEvent(tab, this.fieldManager.getField(itemId.getFieldId())));
        }
        return DefaultFieldScreenService.okServiceResult();
    }

    public ServiceOutcome<List<FieldWithShowWhenEmpty>> getFieldsWithShowWhenEmpty(FieldScreenTabId tabId, FieldScreenOperationContext context) {
        Optional<FieldScreenTab> tab = this.getTabById(tabId);
        if (!tab.isPresent() || !this.projectAdminOrAdministratorPermissionCheck(tab.get().getFieldScreen(), context)) {
            return this.noPermission(context);
        }
        List fieldScreenLayoutItems = tab.get().getFieldScreenLayoutItems();
        List fields = fieldScreenLayoutItems.stream().map(fieldScreenLayoutItem -> Pair.nicePairOf((Object)this.fieldManager.getField(fieldScreenLayoutItem.getFieldId()), (Object)fieldScreenLayoutItem.isShownWhenEmpty())).filter(pair -> pair.first() != null).map(pair -> new ImmutableFieldWithShowWhenEmpty((Field)pair.first(), (Boolean)pair.second())).collect(Collectors.toList());
        return ServiceOutcomeImpl.ok(fields);
    }

    @VisibleForTesting
    AddFieldToScreenUtilImpl getAddFieldToScreenUtil() {
        return new AddFieldToScreenUtilImpl(this.fieldManager, this.fieldScreenManager, this.i18nFactory);
    }

    private static ErrorCollection singleValidationError(String field, String message) {
        return ErrorCollections.create((String)field, (String)message, (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED);
    }

    private static ServiceResultImpl okServiceResult() {
        return new ServiceResultImpl((ErrorCollection)new SimpleErrorCollection());
    }

    private FieldScreenTab getTabByName(FieldScreen screen, String name) {
        List tabs = screen.getTabs();
        for (FieldScreenTab tab : tabs) {
            if (!tab.getName().equals(name)) continue;
            return tab;
        }
        return null;
    }

    private <T> ServiceOutcomeImpl<T> noPermission(FieldScreenOperationContext context) {
        return ServiceOutcomeImpl.error(this.i18nFactory.getInstance(context.getUser()).getText("admin.errors.screens.no.permission"), ErrorCollection.Reason.FORBIDDEN);
    }

    private I18nHelper getI18n(FieldScreenOperationContext context) {
        ApplicationUser applicationUser = context.getUser();
        return this.i18nFactory.getInstance(applicationUser);
    }

    private <T> ServiceOutcomeImpl<T> notDcLicensed(FieldScreenOperationContext context) {
        return ServiceOutcomeImpl.error(this.i18nFactory.getInstance(context.getUser()).getText("admin.project.config.show.empty.custom.fields.notlicensed"), ErrorCollection.Reason.FORBIDDEN);
    }

    private boolean administerPermissionCheck(FieldScreenOperationContext context) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, context.getUser());
    }

    private boolean editScreenPermissionCheck(FieldScreen screen, FieldScreenOperationContext context) {
        return this.projectFieldScreenHelper.canUserEditScreen(context.getUser(), screen);
    }

    private boolean projectAdminOrAdministratorPermissionCheck(FieldScreen fieldScreen, FieldScreenOperationContext context) {
        if (!context.getProject().isPresent()) {
            return this.editScreenPermissionCheck(fieldScreen, context);
        }
        return this.projectFieldScreenHelper.canUserViewFieldScreenForProject(context.getUser(), fieldScreen, (Project)context.getProject().get());
    }

    private Optional<FieldScreen> getScreenById(FieldScreenId screenId) {
        return Optional.ofNullable(this.fieldScreenManager.getFieldScreen(Long.valueOf(screenId.getId())));
    }

    private Optional<FieldScreenTab> getTabById(FieldScreenTabId tabId) {
        return Optional.ofNullable(this.fieldScreenManager.getFieldScreenTab(Long.valueOf(tabId.getId())));
    }
}

